/* Slide show time manager */
(function(window){
	
	var FWDVRLTimerManager = function(delay){
		
		var self = this;
		var prototpype = FWDVRLTimerManager.prototype;
		
		this.timeOutId;
		this.delay = delay;
		this.isStopped_bl = true;
		
		self.stop = function(){
			if(self.isStopped_bl) return;
			self.pause();
			self.isStopped_bl = true;
			self.dispatchEvent(FWDVRLTimerManager.STOP);
		};
		
		self.start = function(){
			if(!self.isStopped_bl) return;
			self.isStopped_bl = false;
			
			self.timeOutId = setTimeout(self.onTimeHanlder, self.delay);
			self.dispatchEvent(FWDVRLTimerManager.START);
		};
		
		self.pause = function(){
			if(self.isStopped_bl) return;
			clearTimeout(self.timeOutId);
			self.dispatchEvent(FWDVRLTimerManager.PAUSE);
		};
		
		self.resume = function(){
			if(self.isStopped_bl) return;
			clearTimeout(self.timeOutId);
			self.timeOutId = setTimeout(self.onTimeHanlder, self.delay);
			self.dispatchEvent(FWDVRLTimerManager.RESUME);
		};
		
		self.onTimeHanlder = function(){
			self.dispatchEvent(FWDVRLTimerManager.TIME);
		};
	};

	FWDVRLTimerManager.setProtptype = function(){
		FWDVRLTimerManager.prototype = new FWDVRLEventDispatcher();
	};
	
	FWDVRLTimerManager.START = "start";
	FWDVRLTimerManager.STOP = "stop";
	FWDVRLTimerManager.RESUME = "resume";
	FWDVRLTimerManager.PAUSE = "pause";
	FWDVRLTimerManager.TIME = "time";
	
	FWDVRLTimerManager.prototype = null;
	window.FWDVRLTimerManager = FWDVRLTimerManager;
	
}(window));