/* FWDVUGPThumbnail */
(function (window){
	
	var FWDVUGPThumbnail = function(props_obj){
		
		var self = this;
		var prototype = FWDVUGPThumbnail.prototype;
		
		this.parent = props_obj.parent;
		this.main_do;
		this.bk_do;
		this.border_do;
		this.imageHolder_do;
		this.image_do;
		this.contentHolder_do;
		this.text1_do;
		this.overlay_do;
		this.fakeBorder_do;
		this.button1_do;
		this.button2_do;
		this.icon_do;
		this.mySplitText;
		this.textHolder_do;
		
		this.presetType_str = props_obj.presetType_str;
		this.backgroundColor_str = props_obj.backgroundColor_str;
		this.borderNormalColor_str = props_obj.borderNormalColor_str;
		this.borderSelectedColor_str = props_obj.borderSelectedColor_str;
		this.htmlContent1_str = props_obj.htmlContent1_str;
		this.htmlContent2_str = props_obj.htmlContent2_str;
		this.htmlExtraContent_str = props_obj.htmlExtraContent_str;
	
		this.overlayColor_str = props_obj.thumbnailOverlayColor_str;
		this.extraButtonUrl_str = props_obj.extraButtonUrl_str;
		this.extraButtonUrlTarget_str = props_obj.extraButtonUrlTarget_str;
		this.iconPathN_str = props_obj.thumbIconPathN_str;
		this.iconPathS_str = props_obj.thumbIconPathS_str;
		this.linkIconPathN_str = props_obj.linkIconPathN_str;
		this.linkIconPathS_str = props_obj.linkIconPathS_str;
		this.hideAndShowTransitionType_str = props_obj.hideAndShowTransitionType_str;
		this.prevAndShowTransitionType_str;
		this.textVerticalAlign_str = props_obj.textVerticalAlign_str;
		this.imageTransitionDirection_str = props_obj.imageTransitionDirection_str;
		this.thumbanilBoxShadow_str = props_obj.thumbanilBoxShadow_str;
		this.animStartDir_str = "top";
		this.textAnimType_str = props_obj.textAnimType_str;
		this.alt_str = props_obj.alt_str;
		this.linkUrl_str = props_obj.linkUrl_str;
		this.linkTarget_str = props_obj.linkTarget_str;
		
		this.catId = props_obj.catId;
		this.id = props_obj.id;
		
		this.contentOffest = props_obj.contentOffsetY;
		this.buttonsOffest = props_obj.buttonsOffest;
		this.borderSize = props_obj.borderSize;
		this.lastBorderSize = this.borderSize;
		this.borderRadius = props_obj.borderRadius; 
		this.overlayOpacity = props_obj.thumbnailOverlayOpacity;
		this.iconW = props_obj.thumbnailIconWidth;
		this.iconH = props_obj.thumbnailIconHeight;
		this.spaceBetweenThumbanilIcons = props_obj.spaceBetweenThumbanilIcons;
		this.spaceBetweenTextAndIcons = props_obj.spaceBetweenTextAndIcons;
		this.imageOriginalW;
		this.imageOriginalH;
		this.tempFinalX = -1;
		this.tempFinalY = -1;
		this.finalX = 0;
		this.finalY = 0;
		this.finalW = 0;
		this.finalH = 0;
		this.prevFinalX = 0;
		this.prevFinalY = 0;
		this.prevFinalW = 0;
		this.prevFinalH = 0;
		this.angleY = -180;
		this.text1H = 0;
		this.text2H = 0;
		this.addToHeight = 0;
		this.finalHOffset = 0; 
		this.hOffset = 0;
		
		this.showOrHideWithDelayId_to;
		this.isImageAnimCompleteId_to;
		this.resizeTextContent1Id_to;
		this.contentHideCompleteId_to;
		this.contentShowCompleteId_to;
		
		this.isVerticalType_bl = props_obj.isVerticalType_bl;
		this.isCheckHitAdded_bl = false;
		this.showIcon_bl = true;
		this.hasButtons_bl = props_obj.useIconButtons_bl;
		this.doNotOverwriteResizeContent_bl = false;
		this.disableThumbnails_bl = props_obj.disableThumbnails_bl;
		this.isImageAnimCompleteId_bl = false;
		this.isLightboxDisabled_bl = props_obj.isDisabled_bl;
		this.imageShowComplete_bl = false;
		this.isContentHidden_bl = true;
		this.hasImage_bl = false;
		this.used_bl = false;
		this.firstTimeLoad_bl = true;
		this.isImageShowed_bl = false;
		this.isFirstTimeShowed_bl = true;
		this.isContentShowed_bl = false;
		this.isHidden_bl = false;
		this.hasExtraText_bl = Boolean(this.htmlExtraContent_str);
		this.isMobile_bl = FWDVRLUtils.isMobile;
		this.hasPointerEvent_bl = FWDVRLUtils.hasPointerEvent;
		
		this.init = function(){
			this.setupMainInstances();
		};
		
		//###################################//
		/* setup main screen */
		//###################################//
		this.setupMainInstances = function(){
					
			if(this.presetType_str == "3d"){
				this.main3dContainer_do = new FWDVUGPDisplayObject3D("div");
				this.main3dContainer_do.setOverflow("visible");
				this.setOverflow("visible");
				this.main3dContainer_do.setPerspective(1000);
				this.main3dContainer_do.setPreserve3D();
				if(this.isVerticalType_bl && !this.isLightboxDisabled_bl && !this.disableThumbnails_bl && !this.hasButtons_bl) this.main3dContainer_do.setButtonMode(true);
				
				this.main_do = new FWDVUGPDisplayObject3D("div");	
				this.main_do.setBackfaceVisibility();
				
				this.main3dContainer_do.addChild(this.main_do);
				this.addChild(this.main3dContainer_do);
			}else{
				this.main_do = new FWDVRLDisplayObject("div");
				this.addChild(this.main_do);
			}
			
			this.bk_do = new FWDVRLDisplayObject("div");
			this.bk_do.setBkColor(this.backgroundColor_str);
			

			this.border_do = new FWDVRLDisplayObject("div");
		
			if(FWDVRLUtils.hasTransform2d && (this.presetType_str == "scaletext"  || this.presetType_str == "scaletextinverse")){
				this.imageHolder_do = new FWDVRLTransformDisplayObject("div");
			}else{
				this.imageHolder_do = new FWDVRLDisplayObject("div");
			}
			
			this.image_do = new FWDVRLDisplayObject("img");
			
			if(!this.isLightboxDisabled_bl && !this.disableThumbnails_bl && !this.hasButtons_bl){
				if(this.isVerticalType_bl) this.border_do.setButtonMode(true);
				if(this.isVerticalType_bl && this.presetType_str == "curtain") this.imageHolder_do.setButtonMode(true);
			}
			
			if(this.thumbanilBoxShadow_str) this.setBorderBoxShadow(this.thumbanilBoxShadow_str);
			this.setupContent();
			this.main_do.addChild(this.bk_do);
			this.main_do.addChild(this.border_do);
			
			if(this.borderSize != 0) this.setBorderSize(this.borderSize);
			if(this.borderRadius != 0) this.setBorderRadius(this.borderRadius);
			this.setBorderColor(this.borderNormalColor_str, this.borderSelectedColor_str);
		};
		
		//######################################//
		/* Add image */
		//######################################//
		this.addImage = function(image){
			this.imageOriginalW = image.width;
			this.imageOriginalH = image.height;
			this.hasImage_bl = true;
			this.image_do.setScreen(image);
			image.setAttribute("alt", this.alt_str);
			
			this.main_do.setAlpha(0);
			this.addEvents();
			//if(!this.hasExtraText_bl) FWDAnimation.to(this.main_do, .7, {alpha:1});
		};
		
		//######################################//
		/* Resize and position */
		//######################################//
		this.resizeAndPosition = function()
		{	
			if ((this.finalX == this.prevFinalX) && (this.finalY == this.prevFinalY) && (this.finalW == this.prevFinalW) && (this.finalH == this.prevFinalH)
					 && (this.prevBorderSize == this.borderSize))
			{
				return;
			}
			else
			{
				this.prevBorderSize = this.borderSize;
				this.prevFinalX = this.finalX;
				this.prevFinalY = this.finalY;
				this.prevFinalW = this.finalW;
				this.prevFinalH = this.finalH;
			}
		
			FWDAnimation.killTweensOf(this);
			
			//this.checkVisibility();
			
			var imageHolderW = this.finalW - this.borderSize * 2;
			var imageHolderH = this.finalH - this.addToHeight - this.borderSize * 2;
			
			var scX = imageHolderW/self.imageOriginalW;
			var scY = imageHolderH/self.imageOriginalH;
			var sct;
			
			if(scX >= scY){
				sct = scX;
			}else{
				sct = scY;
			}
			
			var imageW = parseInt(sct * self.imageOriginalW) + 1;
			var imageH = parseInt(sct * self.imageOriginalH) + 1;
			
			var globalY = Math.abs(Math.min(0, FWDVUGP.globalY));
			var totalVisibleHeight = FWDVUGP.globalY > 0 ? FWDVUGP.viewportHeight - FWDVUGP.globalY : FWDVUGP.viewportHeight;
			var animate_bl;
			
		
			if (this.firstTimeLoad_bl || !self.isImageShowed_bl){
				
				FWDAnimation.killTweensOf(this.image_do);
				FWDAnimation.killTweensOf(this.imageHolder_do);
				
				this.setX(this.finalX);
				this.setY(this.finalY);
				
				this.imageHolder_do.setX((imageHolderW)/2 + this.borderSize);
				this.imageHolder_do.setY((imageHolderH)/2 + this.borderSize);
				
				this.image_do.setWidth(imageW);
				this.image_do.setHeight(imageH);
				
				this.image_do.setX(-imageW/2);
				this.image_do.setY(-imageH/2);
				
				FWDAnimation.to(this.main_do, .7, {alpha:1});
				FWDAnimation.to(this.imageHolder_do, .7, {x:this.borderSize, y:this.borderSize, w:imageHolderW, h:imageHolderH, delay:.2, ease:Quint.easeInOut});
				FWDAnimation.to(this.image_do, .7, {x:parseInt((imageHolderW - imageW)/2), y:parseInt((imageHolderH - imageH)/2), delay:.2, ease:Quint.easeInOut});
				
				if(this.hasExtraText_bl){
					FWDAnimation.to(this.text3_do, .7, {alpha:1, delay:.5});
				}
				
				this.isImageAnimCompleteId_to = setTimeout(function(){
					
					self.isImageAnimCompleteId_bl = true;
					if(self.presetType_str == "media"){
						if(self.text1_do && self.text2_do){
							if(FWDVRLUtils.hitTest(self.screen, self.parent.globalX, self.parent.globalY) && !self.isMobile_bl){
								if(self.textVerticalAlign_str == "bottom"){
									self.text2_do.setY(self.finalH + self.text1H - self.borderSize * 2 + self.contentOffest);
								}else{
									self.text2_do.setY(- self.text1H - self.text2H + self.contentOffest);
								}
								self.showContent();
								self.startToCheckThumbnailHit();
							}else{
								FWDAnimation.killTweensOf(self.text1_do);
								if(self.textVerticalAlign_str == "bottom"){
									FWDAnimation.to(self.text1_do, .7, {y:self.finalH - self.text1H - self.borderSize * 2 + self.contentOffest, ease:Expo.easeInOut});
								}else{
									FWDAnimation.to(self.text1_do, .7, {y:self.contentOffest, ease:Expo.easeInOut});
								}
								
							}
						}
					}else if(self.presetType_str == "media2"){
						if(FWDVRLUtils.hitTest(self.screen, self.parent.globalX, self.parent.globalY) && !self.isMobile_bl){
							self.isContentShowed_bl = false;
							self.showContent();
							self.startToCheckThumbnailHit();
						}
					}else if(self.presetType_str == "scaletextinverse"){
						if(FWDVRLUtils.hitTest(self.screen, self.parent.globalX, self.parent.globalY)){
							self.isContentShowed_bl = false;
							self.showContent();
							self.startToCheckThumbnailHit();
						}else{
							self.isContentShowed_bl = true;
							self.hideContent();
							self.stopToCheckThumbnailHit();
						}
					}else if(!self.isMobile_bl && !self.disableThumbnails_bl){
						if(FWDVRLUtils.hitTest(self.screen, self.parent.globalX, self.parent.globalY)){
							self.showContent();
							self.startToCheckThumbnailHit();
						}
					}
				}, 800);
				
				this.imageHolder_do.addChild(this.image_do);
				
				if(this.presetType_str == "curtain"
				   || this.presetType_str == "3d"){
					this.main_do.addChild(this.imageHolder_do);
				}else{
					this.main_do.addChildAt(this.imageHolder_do, 1);
				}
				
				
				this.isImageShowed_bl = true;
				this.firstTimeLoad_bl = false;	
			}else{
				
				if(this.w != this.finalW || this.h != this.finalH 
					|| this.finalHOffset != this.hOffset
				   || this.lastBorderSize != this.borderSize
				){
					FWDAnimation.killTweensOf(this.image_do);
					FWDAnimation.killTweensOf(this.imageHolder_do);
					this.imageHolder_do.setX(this.borderSize);
					this.imageHolder_do.setY(this.borderSize);
					this.imageHolder_do.setWidth(imageHolderW);
					this.imageHolder_do.setHeight(imageHolderH);
					this.image_do.setX(parseInt((imageHolderW - imageW)/2));
					this.image_do.setY(parseInt((imageHolderH - imageH)/2));
				}
			
				if(this.isMobile_bl || this.isHidden_bl 
					|| !((self.finalY + self.finalH > globalY || self.y + self.finalH > globalY) && (self.finalY - globalY < totalVisibleHeight || self.y - globalY < totalVisibleHeight))
					&& this.isVerticalType_bl){
					this.setX(this.finalX);
					this.setY(this.finalY);
				}else{
					if(FWDVRLUtils.hasTransform2d){
						if(this.hideAndShowTransitionType_str == "scale"){
							FWDAnimation.to(this, .7, {x:this.finalX, y:this.finalY, scale:1, alpha:1, ease:Quart.easeOut});
						}else if(this.hideAndShowTransitionType_str == "opacity"){
							FWDAnimation.to(this, .7, {x:this.finalX, y:this.finalY, alpha:1, ease:Quart.easeOut});
						}else if(this.hideAndShowTransitionType_str == "rotation"){
							FWDAnimation.to(this, .7, {x:this.finalX, y:this.finalY, rotation:0, scale:1, ease:Quart.easeOut});
						}
					}else{
						FWDAnimation.to(this, .7, {x:this.finalX, y:this.finalY, alpha:1, ease:Quart.easeOut});
					}
					
				}
				this.isFirstTimeShowed_bl = false;
				if(self.presetType_str != "scaletextinverse") clearTimeout(this.isImageAnimCompleteId_to);
				this.isImageAnimCompleteId_bl = true;
			}
			
			if(this.w != this.finalW || this.h != this.finalH 
				   || this.finalHOffset != this.hOffset
				   || this.lastBorderSize != this.borderSize
				){
				this.setWidth(this.finalW);
				this.setHeight(this.finalH);
				this.main_do.setWidth(this.finalW);
				this.main_do.setHeight(this.finalH + this.addToHeight);
				this.bk_do.setX(this.borderSize);
				this.bk_do.setY(this.borderSize );
				this.bk_do.setWidth(imageHolderW);
				this.bk_do.setHeight(imageHolderH + this.addToHeight);
				this.border_do.setWidth(imageHolderW);
				this.border_do.setHeight(imageHolderH + this.addToHeight);
				if(this.main3dContainer_do){
					this.main3dContainer_do.setWidth(this.finalW);
					this.main3dContainer_do.setHeight(this.finalH);
				}
				
			
				this.image_do.setWidth(imageW);
				this.image_do.setHeight(imageH);
				
				if(this.hasExtraText_bl){
					this.textHolder_do.setX(this.borderSize);
					this.textHolder_do.setWidth(this.finalW - this.borderSize * 2);
					this.textHolder_do.setY(this.finalH - this.addToHeight - this.borderSize);
				}
				
				this.stopToCheckThumbnailHit();
				
			}
			
			if(this.presetType_str == "media"
			   || this.presetType_str == "media2"
			   || this.presetType_str == "scaletextinverse"
			){
				this.resizeContent();
			}
			this.hOffset = this.finalHOffset;
			this.lastBorderSize = this.borderSize;
		};
		
		//#############################################//
		/* Setup content */
		//#############################################//
		this.setupContent = function(){
		
			if(this.presetType_str == "movetext" 
			    || this.presetType_str == "preset2" 
			    || this.presetType_str == "curtain"
			    || this.presetType_str == "3d"
			    || this.presetType_str == "scaletext"
			    || this.presetType_str == "scaletextinverse"
			    || this.presetType_str == "animtext"
			  ){
				
				if(this.presetType_str == "3d"){
					this.contentHolder_do = new FWDVUGPDisplayObject3D("div");
				}else{
					this.contentHolder_do = new FWDVRLDisplayObject("div");
				}
				
				this.contentHolder_do.setX(-1000);
				
				this.overlay_do = new FWDVRLDisplayObject("div");
				
				this.overlay_do.getStyle().width = "100%";
				this.overlay_do.getStyle().height = "100%";
				this.overlay_do.setBackfaceVisibility(true);
				this.setOverlayColor(this.overlayColor_str);
				
				this.overlay_do.setAlpha(this.overlayOpacity);
				
				if((this.presetType_str == "scaletext" || this.presetType_str == "scaletextinverse") && FWDVRLUtils.hasTransform2d){
					this.text1_do = new FWDVRLTransformDisplayObject("div");
				}else{
					this.text1_do = new FWDVRLDisplayObject("div");
				}
				
				this.text1_do.getStyle().width = "100%";
				this.text1_do.getStyle().fontSmoothing = "antialiased";
				this.text1_do.getStyle().webkitFontSmoothing = "antialiased";
				this.text1_do.getStyle().textRendering = "optimizeLegibility";
				this.text1_do.setY(-500);
			
				if(this.htmlContent1_str) this.text1_do.setInnerHTML(this.htmlContent1_str);
			
				this.contentHolder_do.addChild(this.overlay_do);
				this.contentHolder_do.addChild(this.text1_do);	
				
				if(this.presetType_str == "curtain"){
					this.fakeBorder_do = new FWDVRLDisplayObject("div");
					this.fakeBorder_do.setBkColor(this.borderNormalColor_str);
				}else if(this.presetType_str == "preset2"){
					this.isContentHidden_bl = true;
					this.contentHolder_do.setX(-1000);
				}else if(this.presetType_str == "animtext"){
					this.isContentHidden_bl = true;
					this.contentHolder_do.setX(-1000);
					this.overlay_do.setAlpha(0);
					if(this.htmlContent1_str){
						this.text1_do.screen.setAttribute("id", "FWDVUGP_at" + self.id);
						var children = FWDVRLUtils.getChildren(this.text1_do.screen.firstChild);
						
						var child;
						for(var i=0; i<children.length; i++){
							child = children[i];
							FWDAnimation.killTweensOf(child);
							if(this.textAnimType_str == "scale" || this.textAnimType_str == "scalerandom"){
								FWDAnimation.to(child, 0, {css:{scale:0}});
							}else if(this.textAnimType_str == "largescale"){
								FWDAnimation.to(child, 0, {css:{opacity:0, scale:3}});
							}else if(this.textAnimType_str == "opacity"){
								FWDAnimation.to(child, 0, {css:{opacity:0}});
							}
						}
					}
					
				}
			}else if(this.presetType_str == "preset30"){
				this.contentHolder_do = new FWDVRLDisplayObject("div");
				this.border_do.setButtonMode(false);
				this.hasButtons_bl = true;
			}else if(this.presetType_str == "media"){
				this.contentHolder_do = new FWDVRLDisplayObject("div");
				if(!this.isLightboxDisabled_bl && this.isVerticalType_bl) this.border_do.setButtonMode(true);
				
				if(FWDVRLUtils.hasTransform2d){
					this.text1_do = new FWDVRLTransformDisplayObject("div");
					this.text2_do = new FWDVRLTransformDisplayObject("div");
				}else{
					this.text1_do = new FWDVRLDisplayObject("div");
					this.text2_do = new FWDVRLDisplayObject("div");
				}
				
				if(this.htmlContent1_str){
					this.text1_do.setY(-500);
					this.text1_do.getStyle().width = "100%";
					this.text1_do.getStyle().fontSmoothing = "antialiased";
					this.text1_do.getStyle().webkitFontSmoothing = "antialiased";
					this.text1_do.getStyle().textRendering = "optimizeLegibility";
					this.text1_do.setInnerHTML(this.htmlContent1_str);
				}
		
				if(this.htmlContent1_str && this.htmlContent2_str){
					this.text2_do.setY(-500);
					this.text2_do.getStyle().width = "100%";
					this.text2_do.getStyle().fontSmoothing = "antialiased";
					this.text2_do.getStyle().webkitFontSmoothing = "antialiased";
					this.text2_do.getStyle().textRendering = "optimizeLegibility";
					this.text2_do.setInnerHTML(this.htmlContent2_str);
				}
				
				this.contentHolder_do.addChild(this.text1_do);
				this.contentHolder_do.addChild(this.text2_do);
				this.border_do.addChild(this.contentHolder_do);
			}else if(this.presetType_str == "media2"){
				this.contentHolder_do = new FWDVRLDisplayObject("div");
				
				if(FWDVRLUtils.hasTransform2d){
					this.text1_do = new FWDVRLTransformDisplayObject("div");
				}else{
					this.text1_do = new FWDVRLDisplayObject("div");
				}
				
				if(this.htmlContent1_str){
					this.text1_do.setY(-400);
					this.text1_do.getStyle().width = "100%";
					this.text1_do.getStyle().fontSmoothing = "antialiased";
					this.text1_do.getStyle().webkitFontSmoothing = "antialiased";
					this.text1_do.getStyle().textRendering = "optimizeLegibility";
					this.text1_do.setInnerHTML(this.htmlContent1_str);
				}
				
				this.overlay_do = new FWDVRLDisplayObject("div");
				this.overlay_do.getStyle().width = "100%";
				this.overlay_do.getStyle().height = "100%";
				this.setOverlayColor(this.overlayColor_str);
				this.overlay_do.setAlpha(0);
				//this.overlay_do.setX(-5000);
				
				this.contentHolder_do.addChild(this.overlay_do);
				setTimeout(function(){
					self.contentHolder_do.addChild(self.text1_do);
				}, 50);
			}
			
		
			if(this.hasButtons_bl){
				
				if(!this.isLightboxDisabled_bl){
					FWDVUGPSimpleSizeButton.setPrototype();
					this.button1_do = new FWDVUGPSimpleSizeButton(this.iconPathN_str, this.iconPathS_str, this.iconW, this.iconH);
					this.button1_do.setX(-200);
					this.button1_do.addListener(FWDVUGPSimpleSizeButton.CLICK, this.btn1ClickHandler);
					
					if(this.extraButtonUrl_str){
						FWDVUGPSimpleSizeButton.setPrototype();
						this.button2_do = new FWDVUGPSimpleSizeButton(this.linkIconPathN_str, this.linkIconPathS_str, this.iconW, this.iconH);
						this.contentHolder_do.addChild(this.button2_do);
						this.button2_do.setX(-200);
						this.button2_do.addListener(FWDVUGPSimpleSizeButton.CLICK, this.btn2ClickHandler);
					}
					
					this.contentHolder_do.addChild(this.button1_do);
				}
			}
			
			if(self.presetType_str == "scaletextinverse" || self.presetType_str == "scaletext"){
				this.overlay_do.setAlpha(0);
				this.text1_do.setAlpha(0);
				
			}
			this.setupExtraText();
		};
		
		this.btn1ClickHandler = function(e){
			self.dispatchEvent(FWDVUGPThumbnail.MOUSE_UP, {id:self.id, extraButton:false});
		};
		
		this.btn2ClickHandler = function(e){
			self.dispatchEvent(FWDVUGPThumbnail.MOUSE_UP, {id:self.id, extraButton:true});
		};
		
	
		this.resizeContent = function(){
			//if(!this.isContentShowed_bl) return;
		
			var text1Y = 0;
			var text2Y = 0;
			var offsetH = 0;
			var buttonoffsetW = 0;
			var button1X;
			var button2X;
			var text1H;
			
			this.contentHolder_do.setWidth(this.finalW - this.borderSize * 2);
			this.contentHolder_do.setHeight(this.finalH - this.addToHeight - this.borderSize * 2);
			
			clearTimeout(this.resizeTextContent1Id_to);
			
			if(this.presetType_str == "media" && this.text1_do){
				this.resizeTextContent1Id_to = setTimeout(function(){
	
					self.text1H = self.text1_do.getHeight();
					if(self.text2_do) self.text2H = self.text2_do.getHeight();
					
					if(!self.isImageAnimCompleteId_bl){
						if(self.textVerticalAlign_str == "bottom"){
							text1Y =  Math.round(self.finalH  - self.addToHeight - self.borderSize * 2);
							text2Y = self.finalH  - self.addToHeight - self.borderSize * 2 + self.contentOffest;
						}else{
							text1Y =  - self.text1H + self.contentOffest;
							text2Y =   - self.text2H + self.contentOffest;
						}
					}else{
						if(self.textVerticalAlign_str == "bottom"){
							text1Y =  Math.max(Math.round((self.finalH  - self.addToHeight - self.borderSize * 2 - self.text1H) + self.contentOffest), 0);
							text2Y = self.finalH - self.addToHeight - self.borderSize * 2 + self.contentOffest;
						}else{
							text1Y =  self.contentOffest;
							text2Y = - self.text2H + self.contentOffest;
						}
					}
					
					FWDAnimation.killTweensOf(self.text1_do);
					self.text1_do.setY(text1Y);
					
					if(self.text2_do){
						FWDAnimation.killTweensOf(self.text2_do);
						self.text2_do.setY(text2Y);
					}
				}, 50);
			}else if(this.presetType_str == "media2" && this.text1_do){
				this.resizeTextContent1Id_to = setTimeout(function(){
					self.text1H = self.text1_do.getHeight();
					
					if(self.textVerticalAlign_str == "bottom"){
						text1Y =  Math.round(self.finalH - self.addToHeight);
					}else{
						text1Y =  - self.text1H;
					}
					
					FWDAnimation.killTweensOf(self.text1_do);
					if(text1Y != 0) self.text1_do.setY(text1Y);
				}, 50);
			}else if(this.presetType_str == "movetext" 
			    || this.presetType_str == "preset2"
			    || this.presetType_str == "3d"
			   	|| this.presetType_str == "curtain"
			    || this.presetType_str == "scaletext"
			    || this.presetType_str == "scaletextinverse"
			    || this.presetType_str == "animtext"
			 ){
				
				if(this.button1_do){
					buttonoffsetW = this.button2_do ? this.iconW + this.spaceBetweenThumbanilIcons : 0;
					offsetH = parseInt((this.iconH + this.spaceBetweenTextAndIcons)/2) ;
				}
				
				
				
				this.resizeTextContent1Id_to = setTimeout(function(){
					//if(self.contentHolder_do) self.contentHolder_do.setX(0);
					text1H = self.text1_do.getHeight();
					if(!self.htmlContent1_str){
						self.text1Y = 0;
						text1H = 0;
						self.spaceBetweenTextAndIcons = 0;
					}else if(self.textVerticalAlign_str == "center"){
						self.text1Y = Math.max(Math.round((self.finalH - self.addToHeight - self.borderSize * 2 - text1H)/2) + self.contentOffest, 0) - offsetH;
					}else if(self.textVerticalAlign_str == "bottom"){
						self.text1Y =  Math.max(Math.round((self.finalH - self.addToHeight - self.borderSize * 2 - text1H)) + self.contentOffest, 0);
					}else if(self.textVerticalAlign_str == "top"){
						self.text1Y = + self.contentOffest;
					}
					
					if(self.text1Y < 0) self.text1Y = 0;
					//self.text1_do.setBkColor("#FF0000")
					if(self.button1_do){
						self.button1X = parseInt((self.finalW - self.iconW - buttonoffsetW)/2 - self.borderSize);
						self.button2X = self.button1X + self.iconW + self.spaceBetweenThumbanilIcons;
						
						if(self.textVerticalAlign_str == "center"){
							if(self.htmlContent1_str){
								self.buttonY = self.text1Y + text1H + self.spaceBetweenTextAndIcons + self.contentOffest + self.buttonsOffest;
							}else{
								self.buttonY =  Math.round(((self.finalH  - self.addToHeight) - self.iconH -  self.borderSize * 2)/2) + self.buttonsOffest;
								
							}
						}else if(self.textVerticalAlign_str == "bottom"){
							if(self.htmlContent1_str){
								self.buttonY = self.text1Y - self.iconH - self.spaceBetweenTextAndIcons + self.buttonsOffest;
							}else{
								self.buttonY = self.finalH  - self.addToHeight - self.iconH - self.borderSize * 2 + self.buttonsOffest;
							}
						}else if(self.textVerticalAlign_str == "top"){
							self.buttonY = self.text1Y + text1H + self.spaceBetweenTextAndIcons + self.buttonsOffest;	
						}
						
						if(self.buttonY < 0){
							self.buttonY = 0;
						}else if(self.buttonY > self.finalH - self.addToHeight - self.iconH - self.borderSize * 2){
							self.buttonY = self.finalH - self.addToHeight - self.iconH - self.borderSize * 2 ;
						}
						
						if(self.presetType_str != "movetext"){
							self.button1_do.setX(self.button1X);
							self.button1_do.setY(self.buttonY);
							if(self.button2_do){
								self.button2_do.setX(self.button2X);
								self.button2_do.setY(self.buttonY);
								
							}
						}
					}
					
					if((self.presetType_str != "movetext") || !self.hasButtons_bl){
						self.text1_do.setY(self.text1Y);
					}
					
					if((self.presetType_str == "scaletextinverse")){
						//self.overlay_do.setAlpha(self.overlayOpacity);
						if(FWDVRLUtils.hasTransform2d){
							//self.text1_do.setScale2(1);
						}
						
					}
					
				}, 50);
			}
		};
		
		//#########################################//
		/* Extra text */
		//#########################################//
		this.setupExtraText = function(){
			if(this.hasExtraText_bl){
				this.textHolder_do = new FWDVRLDisplayObject("div");
				this.textHolder_do.setX(this.borderSize);
				this.textHolder_do.getStyle().height = "100%";
				this.addChild(this.textHolder_do);
				
				this.text3_do = new FWDVRLDisplayObject("div");
				this.text3_do.getStyle().width = "100%";
				this.text3_do.getStyle().fontSmoothing = "antialiased";
				this.text3_do.getStyle().webkitFontSmoothing = "antialiased";
				this.text3_do.getStyle().textRendering = "optimizeLegibility";
				this.text3_do.setInnerHTML(this.htmlExtraContent_str);
				this.text3_do.setAlpha(0);
				if(!this.hasButtons_bl) this.text3_do.setButtonMode(true);
				this.textHolder_do.addChild(this.text3_do);
			}
		};
		
		//#############################################//
		/* Add events */
		//#############################################//
		this.addEvents = function(){
			if(this.screen.addEventListener){
				if(this.isMobile_bl){
					if(this.hasPointerEvent_bl){
						this.screen.addEventListener("pointerdown", this.onMouseUp);
					}else{
						this.screen.addEventListener("click", this.onMouseUp);
					}
					
				}else{
					this.screen.addEventListener("mouseover", this.onMouseOver);
					this.screen.addEventListener("click", this.onMouseUp);
				}
			}else if(this.screen.attachEvent){
				this.screen.attachEvent("onmouseover", this.onMouseOver);
				this.screen.attachEvent("onclick", this.onMouseUp);
			}
		};
		
		self.onMouseOver = function(e){
			if(self.isContentShowed_bl || self.disableThumbnails_bl) return;
			if((self.presetType_str == "curtain" 
				|| self.presetType_str == "3d"
				|| self.presetType_str == "animtext"
				|| self.presetType_str == "movetext"
				|| self.presetType_str == "preset2"
				|| self.presetType_str == "scaletext") && !self.isImageAnimCompleteId_bl) return;
			
			if(self.presetType_str == "preset2" && !self.htmlContent1_str) return;
			if(self.presetType_str == "3d" && self.isLightboxDisabled_bl && !self.htmlContent1_str) return;
			if(e) self.getInOrOutAngle(e);
			self.showContent();
			self.startToCheckThumbnailHit();
		};
		
		self.onMouseUp = function(e){
			if(e.button == 2 || self.disableThumbnails_bl) return;
			if(!self.isContentShowed_bl && self.isMobile_bl){
				self.onMouseOver();
				return;
			}
			
			if(self.button1_do || self.isLightboxDisabled_bl) return;
			self.dispatchEvent(FWDVUGPThumbnail.MOUSE_UP, {id:self.id});
		};
		
		//########################################//
		/* Check thumbanil hit */
		//########################################//
		this.startToCheckThumbnailHit = function(){
			if(this.isCheckHitAdded_bl) return;
			this.isCheckHitAdded_bl = true;
			
			if(self.isMobile_bl){
				setTimeout(function(){
					if(FWDVRLUtils.isIOS){
						self.hitThhumbnailId_to = window.addEventListener("touchstart", self.checkThumbnailHit);
					}else{
						self.hitThhumbnailId_to = window.addEventListener("click", self.checkThumbnailHit);
					}
				}, 50);
			}else{
				if(window.addEventListener){
					window.addEventListener("mousemove", self.checkThumbnailHit);
				}else{
					document.attachEvent("onmousemove", self.checkThumbnailHit);
				}
				
			}
			
		};
		
		this.stopToCheckThumbnailHit = function(){
			if(!self.isCheckHitAdded_bl) return;
			self.isCheckHitAdded_bl = false;
		
			if(self.isMobile_bl){
				if(FWDVRLUtils.isIOS){
					self.hitThhumbnailId_to = window.removeEventListener("touchstart", self.checkThumbnailHit);
				}else{
					self.hitThhumbnailId_to = window.removeEventListener("click", self.checkThumbnailHit);
				}
			}else{
				if(window.removeEventListener){
					window.removeEventListener("mousemove", self.checkThumbnailHit);
				}else{
					document.detachEvent("onmousemove", self.checkThumbnailHit);
				}
			}
			
			clearTimeout(self.hitThhumbnailId_to);
			self.hideContent(true);
		};
		
		this.checkThumbnailHit = function(e){
			var vc = FWDVRLUtils.getViewportMouseCoordinates(e);	
			if(!FWDVRLUtils.hitTest(self.screen, vc.screenX, vc.screenY)){
				if(self.presetType_str != "3d")  self.getInOrOutAngle(e);
				self.stopToCheckThumbnailHit();
				return;
			}
		};
		
		//#############################################//
		/* Show / hide content */
		//#############################################//
		this.showContent = function(){
			if(this.isContentShowed_bl || this.isHidden_bl) return;
			var children;
			var child;
			var delay1 = 0;
			var button1Delay = 0;
			var button2Delay = 0;
			var contentDelay = 0;
			var text1H;
			var alpha = 0;
			var scale = 0;
			var overlayOpacity = 0;
			var mainTransitionDuration;
			var borderTweenDuration = .6;
			var offsetW;
			var button1X;
			var button1finalY;
			var button2X;
			var button2finalY;
			var borderEase_str;
			var button1Delay;
			var button2Delay;
			
			if(this.presetType_str == "animtext"){
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				clearTimeout(this.showOrHideWithDelayId_to);
				
				this.showOrHideWithDelayId_to = setTimeout(function(){
					if(self.isContentHidden_bl){
						self.contentHolder_do.setX(0);
						if(self.htmlContent1_str){
							children = FWDVRLUtils.getChildren(self.text1_do.screen.firstChild);
							child;
							for(var i=0; i<children.length; i++){
								child = children[i];
								if(self.textAnimType_str == "scale"){
									FWDAnimation.to(child, 1.2, {css:{scale:1}, delay:delay1, ease:Elastic.easeOut});
									delay1 += .035;
								}else if(self.textAnimType_str == "scalerandom"){
									FWDAnimation.to(child, 1.2, {css:{scale:1}, delay:Math.random() * .8, ease:Elastic.easeOut});
								}else if(self.textAnimType_str == "largescale"){
									FWDAnimation.to(child, .6, {css:{opacity:1, scale:1}, delay:Math.random() * .5, ease:Expo.easeInOut});
								}else if(self.textAnimType_str == "opacity"){
									FWDAnimation.to(child, .8, {css:{opacity:1}, delay:delay1});
									delay1 += .030;
								}
							}
						}
						FWDAnimation.to(self.overlay_do, mainTransitionDuration, {alpha:self.overlayOpacity, ease:Quint.easeOut});
					}
				}, 51);
				
				if(this.button1_do){
					if(FWDVRLUtils.hasTransform2d){
						this.button1_do.setScale2(0);
						this.button1_do.setAlpha(0);
						FWDAnimation.to(this.button1_do, mainTransitionDuration + .4, {alpha:1, scale:1, delay:.1, ease:Elastic.easeOut});
						
						if(this.button2_do){
							this.button2_do.setScale2(0);
							this.button2_do.setAlpha(0);
							FWDAnimation.to(this.button2_do, mainTransitionDuration + .4, {alpha:1, scale:1, delay:.2 ,ease:Elastic.easeOut});
						}
					}else{	
						this.button1_do.setAlpha(0);
						FWDAnimation.to(this.button1_do, mainTransitionDuration, {alpha:1, delay:.2 ,ease:Expo.easeInOut});
					
						if(this.button2_do){
							this.button2_do.setAlpha(0);
							FWDAnimation.to(this.button2_do, mainTransitionDuration, {alpha:1, delay:.3 ,ease:Expo.easeInOut});
						}
					}
				}
				
				this.border_do.addChild(this.contentHolder_do);
				this.resizeContent();
			}else if(this.presetType_str == "media2"){
				
				if(!self.isImageAnimCompleteId_bl) return;
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				if(this.isContentHidden_bl){
					self.contentHolder_do.setX(0);
					this.overlay_do.setAlpha(0);
					
					if(this.button1_do){
						offsetW = this.button2_do ? this.iconW + this.spaceBetweenThumbanilIcons : 0;
						button1X = parseInt((this.finalW - this.iconW - offsetW)/2) - this.borderSize;	
						button2X = button1X + this.iconW + this.spaceBetweenThumbanilIcons;
						
						this.button1_do.setX(button1X);
						if(self.textVerticalAlign_str == "bottom"){
							this.button1_do.setY(this.finalH - this.borderSize * 2) - 50;
						}else{
							this.button1_do.setY(self.borderSize);
						}
						this.button1_do.setAlpha(0);
					}
					
					if(this.button2_do){
						this.button2_do.setX(button2X);
						if(self.textVerticalAlign_str == "bottom"){
							this.button2_do.setY(this.finalH - this.borderSize * 2);
						}else{
							this.button2_do.setY(self.borderSize);
						}
						this.button2_do.setAlpha(0);
					}
					
					this.isContentHidden_bl = false;
				}
				this.border_do.addChildAt(this.contentHolder_do, 0);
				this.resizeContent();
				
				clearTimeout(this.showOrHideWithDelayId_to);
			
				this.showOrHideWithDelayId_to = setTimeout(function(){
					text1H = self.text1_do.getHeight();
					var button1finalY;
					var imgY;
					var text1Y;
					
					FWDAnimation.killTweensOf(self.overlay_do);
					FWDAnimation.killTweensOf(self.text1_do);
					FWDAnimation.killTweensOf(self.imageHolder_do);
					FWDAnimation.to(self.overlay_do, mainTransitionDuration - .051, {alpha:self.overlayOpacity, ease:Quint.easeOut});
					
					if(self.textVerticalAlign_str == "bottom"){
						text1Y = self.finalH - text1H - self.borderSize * 2;
						imgY = parseInt(-text1H/2) + self.borderSize;
						button1finalY = parseInt((self.finalH - text1H - self.iconH)/2) - self.borderSize;
					}else{
						text1Y = 0;
						imgY = parseInt(text1H/2) + self.borderSize;
						button1finalY =  parseInt((self.finalH + text1H - self.iconH)/2)  - self.borderSize;
					}
					
					FWDAnimation.to(self.text1_do, mainTransitionDuration - .151, {y:text1Y, ease:Quint.easeInOut});
					FWDAnimation.to(self.imageHolder_do, mainTransitionDuration - .151, {y:imgY, ease:Quint.easeInOut});
					
					if(self.button1_do){
						FWDAnimation.killTweensOf(self.button1_do);
						FWDAnimation.to(self.button1_do, mainTransitionDuration - .151, {y:button1finalY, alpha:1, delay:.05, ease:Quint.easeInOut});
					}
					
					if(self.button2_do){
						FWDAnimation.killTweensOf(self.button2_do);
						FWDAnimation.to(self.button2_do, mainTransitionDuration - .151, {y:button1finalY, alpha:1, delay:.1, ease:Quint.easeInOut});
					}
					
				}, 51);
			}else if(this.presetType_str == "media"){
				if(!self.isImageAnimCompleteId_bl) return;
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				self.contentHolder_do.setX(0);
				
				if(this.icon_do){
					FWDAnimation.to(this.icon_do, mainTransitionDuration, {alpha:1, ease:Expo.easeInOut});
				}
				
				if(this.text1_do && this.text2_do){
					if(self.textVerticalAlign_str == "bottom"){
						FWDAnimation.to(this.text1_do, mainTransitionDuration, {y:this.finalH - this.borderSize * 2 -this.text1H - this.text2H, ease:Expo.easeInOut});
						FWDAnimation.to(this.text2_do, mainTransitionDuration, {y:this.finalH - this.borderSize * 2 - this.text2H, ease:Expo.easeInOut});
					}else{
						FWDAnimation.to(this.text1_do, mainTransitionDuration, {y:this.text2H, ease:Expo.easeInOut});
						FWDAnimation.to(this.text2_do, mainTransitionDuration, {y:0, ease:Expo.easeInOut});
					}
				}
			}else if(this.presetType_str == "scaletextinverse"){
				if(!this.isImageAnimCompleteId_bl) return;
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				alpha = 0;
				scale = 0;
				delay1 = .1;
				overlayOpacity = 0;
				this.contentHolder_do.setX(0);
				this.isContentHidden_bl = false;
				
				if(FWDVRLUtils.hasTransform2d){
					FWDAnimation.killTweensOf(this.imageHolder_do);	
					FWDAnimation.to(this.imageHolder_do, mainTransitionDuration, {scale:1, rotation:0, ease:Expo.easeInOut});
				}
				
				FWDAnimation.killTweensOf(this.overlay_do);	
				FWDAnimation.to(this.overlay_do, mainTransitionDuration, {alpha:overlayOpacity, delay:delay1, ease:Quint.easeOut});
				
				FWDAnimation.killTweensOf(this.text1_do);
				if(FWDVRLUtils.hasTransform2d){
					FWDAnimation.to(this.text1_do, mainTransitionDuration, {scale:scale, alpha:alpha,  ease:Expo.easeInOut});
				}else{
					FWDAnimation.to(this.text1_do, mainTransitionDuration, {alpha:alpha, ease:Expo.easeInOut});
				}
				
				this.border_do.addChild(this.contentHolder_do);
			}else if(this.presetType_str == "scaletext"){
				if(!this.isImageAnimCompleteId_bl) return;
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				
				alpha = 1;
				scale = 1;
				delay1 = .1;
				overlayOpacity = this.overlayOpacity;
				this.contentHolder_do.setX(0);
				
				if(FWDVRLUtils.hasTransform2d){
					FWDAnimation.killTweensOf(this.imageHolder_do);	
					FWDAnimation.to(this.imageHolder_do, mainTransitionDuration, {scale:1.4, rotation:parseInt(-10 + Math.random() * 20), ease:Expo.easeInOut});
				}
			
				
				//this.overlay_do.setAlpha(0);
				//if(FWDVRLUtils.hasTransform2d) this.text1_do.setScale2(0);
				//this.text1_do.setAlpha(0);
				this.isContentHidden_bl = false;
				
				if(this.button1_do){
					if(FWDVRLUtils.hasTransform2d){
						this.button1_do.setScale2(0);
						this.button1_do.setAlpha(0);
						FWDAnimation.to(this.button1_do, mainTransitionDuration, {alpha:1, scale:1, delay:.2 ,ease:Expo.easeInOut});
						
						if(this.button2_do){
							this.button2_do.setScale2(0);
							this.button2_do.setAlpha(0);
							FWDAnimation.to(this.button2_do, mainTransitionDuration, {alpha:1, scale:1, delay:.3 ,ease:Expo.easeInOut});
						}
					}else{	
						this.button1_do.setAlpha(0);
						FWDAnimation.to(this.button1_do, mainTransitionDuration, {alpha:1, delay:.2 ,ease:Expo.easeInOut});
					
						if(this.button2_do){
							this.button2_do.setAlpha(0);
							FWDAnimation.to(this.button2_do, mainTransitionDuration, {alpha:1, delay:.3 ,ease:Expo.easeInOut});
						}
					}
				}
				
				
				FWDAnimation.killTweensOf(this.overlay_do);	
				FWDAnimation.to(this.overlay_do, mainTransitionDuration, {alpha:overlayOpacity, delay:delay1, ease:Quint.easeOut});
				
				FWDAnimation.killTweensOf(this.text1_do);
				if(FWDVRLUtils.hasTransform2d){
					FWDAnimation.to(this.text1_do, mainTransitionDuration, {scale:scale, alpha:alpha,  ease:Expo.easeInOut});
				}else{
					FWDAnimation.to(this.text1_do, mainTransitionDuration, {alpha:alpha, ease:Expo.easeInOut});
				}
				
				this.border_do.addChild(this.contentHolder_do);
				this.resizeContent();
			}else if(this.presetType_str == "movetext"){
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				this.border_do.addChild(this.contentHolder_do);
				this.resizeContent();
			
				if(this.hasButtons_bl){
					clearTimeout(this.showOrHideWithDelayId_to);
					this.showOrHideWithDelayId_to = setTimeout(function(){
						if(self.isContentHidden_bl){
							self.contentHolder_do.setX(0);
							if (self.animStartDir_str == "top"){
								self.overlay_do.setX(0);
								self.overlay_do.setY(-self.finalH + self.borderSize * 2);
								self.text1_do.setX(0);
								self.text1_do.setY(-self.finalH + self.borderSize * 2);
								if(self.button1_do){
									self.button1_do.setX(self.button1X);
									self.button1_do.setY(-self.iconH);
									self.button1_do.setAlpha(0);
								}
								
								if(self.button2_do){
									self.button2_do.setX(self.button2X);
									self.button2_do.setY(-self.iconH);
									self.button2_do.setAlpha(0);
								}
								
								button1Delay = 0;
								button2Delay = .05;
							}else if (self.animStartDir_str == "right"){
								self.overlay_do.setY(0);
								self.overlay_do.setX(self.finalW - (self.borderSize * 2));
								self.text1_do.setX(self.finalW - (self.borderSize * 2));
								self.text1_do.setY(self.text1Y);
								
								if(self.button1_do){
									self.button1_do.setX(self.finalW - self.borderSize * 2);
									self.button1_do.setY(self.buttonY);
									self.button1_do.setAlpha(0);
								}
								
								if(self.button2_do){
									self.button2_do.setX(self.finalW + self.iconW - self.borderSize * 2);
									self.button2_do.setY(self.buttonY);
									self.button2_do.setAlpha(0);
								}
								
								button1Delay = 0;
								button2Delay = .05;
							}else if (self.animStartDir_str == "bottom"){
								self.overlay_do.setX(0);
								self.overlay_do.setY(self.finalH - self.borderSize * 2);
								self.text1_do.setX(0);
								self.text1_do.setY(self.finalH - self.borderSize * 2);
								
								if(self.button1_do){
									self.button1_do.setX(self.button1X);
									self.button1_do.setY(self.finalH - self.borderSize * 2);
									self.button1_do.setAlpha(0);
								}
								
								if(self.button2_do){
									self.button2_do.setX(self.button2X);
									self.button2_do.setY(self.finalH - self.borderSize * 2);
									self.button2_do.setAlpha(0);
								}
								
								button1Delay = 0;
								button2Delay = .05;
							}else if (self.animStartDir_str == "left"){
								
								self.overlay_do.setX(-self.finalW + (self.borderSize * 2));
								self.overlay_do.setY(0);
								self.text1_do.setX(-self.finalW + (self.borderSize * 2));
								self.text1_do.setY(self.text1Y);
								
								if(self.button1_do){
									FWDAnimation.killTweensOf(self.button1_do);
									if(self.button2_do){
										self.button1_do.setX(-self.iconW * 2 - self.spaceBetweenThumbanilIcons);
									}else{
										self.button1_do.setX(-self.iconW);
									}
								
									self.button1_do.setY(self.buttonY);
									self.button1_do.setAlpha(0);
								}
								
								if(self.button2_do){
									FWDAnimation.killTweensOf(self.button2_do);
									self.button2_do.setX(-self.iconW);
									self.button2_do.setY(self.buttonY);
									self.button2_do.setAlpha(0);
									button1Delay = 0.05;
								}
								
								button2Delay = 0;
							}
						}
						
						FWDAnimation.killTweensOf(self.contentHolder_do);	
						FWDAnimation.to(self.overlay_do, .4, {x:0, y:0});
						FWDAnimation.killTweensOf(self.text1_do);	
						FWDAnimation.to(self.text1_do, .4, {x:0, y:self.text1Y});
						
						if(self.button1_do){
							FWDAnimation.to(self.button1_do, .7, {x:self.button1X, y:self.buttonY, alpha:1, delay:button1Delay, ease:Expo.easeInOut});
						}
						
						if(self.button2_do){
							FWDAnimation.to(self.button2_do, .7, {x:self.button2X, y:self.buttonY, alpha:1, delay:button2Delay, ease:Expo.easeInOut});
						}
						self.isContentHidden_bl = false;
					}, 51);
					
				}else{
					mainTransitionDuration = .4;
					if(this.isContentHidden_bl){
						if (this.animStartDir_str == "top"){
							this.contentHolder_do.setX(0);
							this.contentHolder_do.setY(-this.finalH + (this.borderSize * 2));
						}else if (this.animStartDir_str == "right"){
							this.contentHolder_do.setX(this.finalW - (this.borderSize * 2));
							this.contentHolder_do.setY(0);
						}else if (this.animStartDir_str == "bottom"){
							this.contentHolder_do.setX(0);
							this.contentHolder_do.setY(this.finalH - (this.borderSize * 2));
						}else if (this.animStartDir_str == "left"){
							this.contentHolder_do.setX(-this.finalW + (this.borderSize * 2));
							this.contentHolder_do.setY(0);
						}
					}
					
					this.isContentHidden_bl = false;
					FWDAnimation.killTweensOf(this.contentHolder_do);	
					FWDAnimation.to(this.contentHolder_do, mainTransitionDuration, {x:0, y:0});
				}
			}else if(this.presetType_str == "curtain"){
				var finalX = this.borderSize;
				var finalY = this.borderSize;
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				self.contentHolder_do.setX(0);
				
				if(this.imageTransitionDirection_str == "top"){
					finalY = -this.finalH + this.borderSize * 3 - 1;
					this.fakeBorder_do.setWidth(this.finalW);
					this.fakeBorder_do.setHeight(this.borderSize);
				}else if(this.imageTransitionDirection_str == "right"){
					finalX = this.finalW - this.borderSize;
					this.fakeBorder_do.setX(this.finalW - this.borderSize);
					this.fakeBorder_do.setWidth(this.borderSize);
					this.fakeBorder_do.setHeight(this.finalH);
				}else if(this.imageTransitionDirection_str == "bottom"){
					finalY = this.finalH - this.borderSize;
					this.fakeBorder_do.setY(this.finalH - this.borderSize);
					this.fakeBorder_do.setWidth(this.finalW);
					this.fakeBorder_do.setHeight(this.borderSize);
				}else if(this.imageTransitionDirection_str == "left"){
					finalX = - this.finalW + this.borderSize * 3;
					this.fakeBorder_do.setWidth(this.borderSize);
					this.fakeBorder_do.setHeight(this.finalH);
				}
				
				this.addChild(this.fakeBorder_do);
				this.border_do.addChild(this.contentHolder_do);
				this.resizeContent();
				
				if(this.borderSize != 0){
					FWDAnimation.to(this.fakeBorder_do.screen, borderTweenDuration, {css:{backgroundColor:this.borderSelectedColor_str}, ease:borderEase_str});
				}
			
				FWDAnimation.to(this.imageHolder_do, mainTransitionDuration, {x:finalX, y:finalY, ease:Expo.easeInOut});
			}else if(this.presetType_str == "3d"){
				
				mainTransitionDuration = .8;
				borderTweenDuration = .8;
				borderEase_str = Circ.easeOut;
				
				if(this.isVerticalType_bl){
					this.parent.addChild(this);
				}else{
					this.parent.thumbnailsHolder_do.addChild(this);
				}
				
				this.border_do.addChild(this.contentHolder_do);
				this.resizeContent();
			
				if(this.isContentHidden_bl){
					this.prevAnimStartDir_str = this.animStartDir_str;
					if (this.animStartDir_str == "top"){
						this.angleX = -180;
						this.angleY = 0;
						this.contentHolder_do.setAngleX(180);
						this.contentHolder_do.setAngleY(0);
					}else if(this.animStartDir_str == "right"){
						this.angleX = 0;
						this.angleY = -180;
						this.contentHolder_do.setAngleX(0);
						this.contentHolder_do.setAngleY(180);
					}else if (this.animStartDir_str == "bottom"){
						this.angleX = 180;
						this.angleY = 0;
						this.contentHolder_do.setAngleY(0);
						this.contentHolder_do.setAngleX(-180);
					}else if (this.animStartDir_str == "left"){
						this.angleX = 0;
						this.angleY = 180;
						this.contentHolder_do.setAngleX(0);
						this.contentHolder_do.setAngleY(-180);
					}
					this.contentHolder_do.setZ(3);
					this.isContentHidden_bl = false;
				}
				
				this.resizeContent();
				this.contentHolder_do.setX(this.borderSize);
				this.contentHolder_do.setY(this.borderSize);
				this.main3dContainer_do.addChild(this.contentHolder_do);
				
				FWDAnimation.killTweensOf(this.main_do);	
				FWDAnimation.killTweensOf(this.contentHolder_do);
				FWDAnimation.to(this.main_do, mainTransitionDuration, {angleX:self.angleX, angleY:self.angleY, alpha:1, delay:.1, ease:Quint.easeOut});
				FWDAnimation.to(this.contentHolder_do, mainTransitionDuration, {angleX:0, angleY:0, delay:.1, ease:Quint.easeOut});
			}
			
			if(this.borderNormalColor_str != this.borderSelectedColor_str && this.borderSize != 0){
				FWDAnimation.to(this.border_do.screen, borderTweenDuration, {css:{borderColor:this.borderSelectedColor_str}, ease:borderEase_str});
			}
			
			this.isContentShowed_bl = true;
			clearTimeout(this.contentShowCompleteId_to);
			clearTimeout(this.contentHideCompleteId_to);
			this.contentShowCompleteId_to = setTimeout(this.showContentComplete, mainTransitionDuration * 1000);
			
		};
		
		this.showContentComplete = function(){
			clearTimeout(self.contentShowCompleteId_to);
			clearTimeout(self.contentHideCompleteId_to);
			//self.isContentHidden_bl = true;
			//console.log("show complete")
		};
		
		this.hideContent = function(){
			if(!this.isContentShowed_bl) return;
			var child;
			var children;
			var borderEase_str;
			var delay1;
			var alpha = 0;
			var scale = 0;
			var overlayOpacity = 0;
			var mainTransitionDuration;
			var borderTweenDuration = .6;
			var newX;
			var newY;
			var dl;
			var textY;
			var textX;
			var button1Delay = 0;
			var button2Delay = 0;
			var button1X = 0;
			var button1Y = 0;
			var button2X = 0;
			var button2Y = 0;
			
			if(this.presetType_str == "animtext"){
				
				mainTransitionDuration = .4;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				clearTimeout(this.showOrHideWithDelayId_to);
				
				if(this.htmlContent1_str){
				children = FWDVRLUtils.getChildren(self.text1_do.screen.firstChild);
					for(var i=0; i<children.length; i++){
						child = children[i];
						FWDAnimation.killTweensOf(child);
						if(self.textAnimType_str == "scale"){
							FWDAnimation.to(child, .2, {css:{scale:0}});
						}else if(self.textAnimType_str == "scalerandom"){
							FWDAnimation.to(child, .2, {css:{scale:0}});
						}else if(self.textAnimType_str == "largescale"){
							FWDAnimation.to(child, .2, {css:{scale:3, opacity:0}});
						}else if(self.textAnimType_str == "opacity"){
							FWDAnimation.to(child, .2, {css:{opacity:0}});
						}
					}
				}
				
				if(this.button1_do){
					if(FWDVRLUtils.hasTransform2d){
						FWDAnimation.killTweensOf(this.button1_do);
						FWDAnimation.to(this.button1_do, mainTransitionDuration, {alpha:0, scale:0, ease:Quint.easeOut});
						
						if(this.button2_do){
							FWDAnimation.killTweensOf(this.button2_do);
							FWDAnimation.to(this.button2_do, mainTransitionDuration, {alpha:0, scale:0, ease:Quint.easeOut});
						}
					}else{	
						FWDAnimation.killTweensOf(this.button1_do);
						FWDAnimation.to(this.button1_do, mainTransitionDuration, {alpha:0, ease:Expo.easeInOut});
					
						if(this.button2_do){
							FWDAnimation.killTweensOf(this.button2_do);
							FWDAnimation.to(this.button2_do, mainTransitionDuration, {alpha:0 , ease:Expo.easeInOut});
						}
					}
				}
				
				FWDAnimation.to(self.overlay_do, mainTransitionDuration, {alpha:0, ease:Quint.easeOut});
			}else if(this.presetType_str == "media2"){
				if(!self.isImageAnimCompleteId_bl) return;
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				clearTimeout(this.showOrHideWithDelayId_to);
				this.showOrHideWithDelayId_to = setTimeout(function(){
					
					var text1H = self.text1_do.getHeight();
					var imgY;
					var text1Y;
					
					FWDAnimation.killTweensOf(self.overlay_do);
					FWDAnimation.killTweensOf(self.text1_do);
					FWDAnimation.killTweensOf(self.imageHolder_do);
					FWDAnimation.to(self.overlay_do, mainTransitionDuration - .051, {alpha:0, ease:Quint.easeOut});
					
					if(self.textVerticalAlign_str == "bottom"){
						text1Y = self.finalH - self.borderSize * 2;
						imgY = self.borderSize;
						button1finalY = self.finalH - self.borderSize * 2;
					}else{
						text1Y = - text1H;
						imgY = self.borderSize;
						button1finalY = - self.iconH;
					}
					
					FWDAnimation.to(self.text1_do, mainTransitionDuration - .151, {y:text1Y, ease:Quint.easeInOut});
					FWDAnimation.to(self.imageHolder_do, mainTransitionDuration - .151, {y:imgY, ease:Quint.easeInOut});
					
					if(self.button1_do){
						FWDAnimation.killTweensOf(self.button1_do);
						FWDAnimation.to(self.button1_do, mainTransitionDuration - .151, {y:button1finalY, alpha:1, delay:.05, ease:Quint.easeInOut});
					}
					
					if(self.button2_do){
						FWDAnimation.killTweensOf(self.button2_do);
						FWDAnimation.to(self.button2_do, mainTransitionDuration - .151, {y:button1finalY, alpha:1, delay:.1, ease:Quint.easeInOut});
					}
				}, 51);
			}else if(this.presetType_str == "media"){
				if(!this.isImageAnimCompleteId_bl) return;
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				if(this.icon_do){
					FWDAnimation.to(this.icon_do, mainTransitionDuration, {alpha:0, ease:Expo.easeInOut});
				}
				
				if(this.text1_do && this.text2_do){
					if(self.textVerticalAlign_str == "bottom"){
						FWDAnimation.to(this.text1_do, mainTransitionDuration, {y:this.finalH - this.borderSize * 2 -this.text1H, ease:Expo.easeInOut});
						FWDAnimation.to(this.text2_do, mainTransitionDuration, {y:this.finalH - this.borderSize * 2, ease:Expo.easeInOut});
					}else{
						FWDAnimation.to(this.text1_do, mainTransitionDuration, {y:0, ease:Expo.easeInOut});
						FWDAnimation.to(this.text2_do, mainTransitionDuration, {y:- this.text2H, ease:Expo.easeInOut});
					}
					
				}
			}else if(this.presetType_str == "scaletextinverse"){
				if(!this.isImageAnimCompleteId_bl) return;
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				alpha = 1;
				scale = 1;
				delay1 = .1;
				overlayOpacity = this.overlayOpacity;
				this.contentHolder_do.setX(0);
				
				if(FWDVRLUtils.hasTransform2d){
					FWDAnimation.killTweensOf(this.imageHolder_do);	
					FWDAnimation.to(this.imageHolder_do, mainTransitionDuration, {scale:1.4, rotation:parseInt(-10 + Math.random() * 20), ease:Expo.easeInOut});
				}
				
				FWDAnimation.killTweensOf(this.overlay_do);	
				FWDAnimation.to(this.overlay_do, mainTransitionDuration, {alpha:overlayOpacity, delay:delay1, ease:Quint.easeOut});
				
				FWDAnimation.killTweensOf(this.text1_do);
				if(FWDVRLUtils.hasTransform2d){
					FWDAnimation.to(this.text1_do, mainTransitionDuration, {scale:scale, alpha:alpha,  ease:Expo.easeInOut});
				}else{
					FWDAnimation.to(this.text1_do, mainTransitionDuration, {alpha:alpha, ease:Expo.easeInOut});
				}
				
				this.isContentHidden_bl = false;
				this.border_do.addChild(this.contentHolder_do);
				this.resizeContent();
			}else if(this.presetType_str == "scaletext"){
				if(!this.isImageAnimCompleteId_bl) return;
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				if(this.presetType_str == "scaletext"){
					alpha = 0;
					scale = 0;
					overlayOpacity = 0;
					delay1 = .2;
					if(this.button1_do){
						FWDAnimation.killTweensOf(this.button1_do);
						if(FWDVRLUtils.hasTransform2d){
							FWDAnimation.to(this.button1_do, .4, {alpha:0, scale:0, ease:Quint.easeOut});
							if(this.button2_do){
								FWDAnimation.killTweensOf(this.button2_do);
								FWDAnimation.to(this.button2_do, .4, {alpha:0, scale:0,ease:Quint.easeOut});
							}
						}else{
							FWDAnimation.to(this.button1_do, .4, {alpha:0,  ease:Quint.easeOut});
							if(this.button2_do){
								FWDAnimation.killTweensOf(this.button2_do);
								FWDAnimation.to(this.button2_do, .4, {alpha:0, ease:Quint.easeOut});
							}
						}
					}
					if(FWDVRLUtils.hasTransform2d){
						FWDAnimation.killTweensOf(this.imageHolder_do);	
						FWDAnimation.to(this.imageHolder_do, mainTransitionDuration, {scale:1, rotation:0, ease:Expo.easeInOut});
					}
				}
				
				this.isContentHidden_bl = false;
				FWDAnimation.killTweensOf(this.overlay_do);	
				FWDAnimation.to(this.overlay_do, mainTransitionDuration, {alpha:overlayOpacity, delay:delay1, ease:Quint.easeOut});
				
				FWDAnimation.killTweensOf(this.text1_do);
				if(FWDVRLUtils.hasTransform2d){
					FWDAnimation.to(this.text1_do, mainTransitionDuration, {scale:scale, alpha:alpha,  ease:Expo.easeInOut});
				}else{
					FWDAnimation.to(this.text1_do, mainTransitionDuration, {alpha:alpha, ease:Expo.easeInOut});
				}
			}else if(this.presetType_str == "movetext"){
				
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				clearTimeout(this.showOrHideWithDelayId_to);
				
				if(this.button1_do){
					if (this.animStartDir_str == "top"){
						contentX = 0;
						contentY = -this.finalH + this.borderSize * 2;
						textX = 0;
						textY = contentY;
						button1X = this.button1X;
						button1Y = -this.iconH;
						button2X = this.button2X;
						button2Y = button1Y;
						if(this.button2_do) button2Delay = .05;
					}else if (this.animStartDir_str == "right"){
						contentX = this.finalW - this.borderSize * 2;
						contentY = 0;
						textX = contentX;
						textY = this.text1Y;
						button1X = contentX;
						button1Y = this.buttonY;
						button2X = contentX + this.iconW + this.spaceBetweenThumbanilIcons;
						button2Y = this.buttonY;
						if(this.button2_do) button1Delay = .05;
					}else if (this.animStartDir_str == "bottom"){
						contentX = 0;
						contentY = this.finalH - this.borderSize * 2;
						textX = 0;
						textY = contentY;
						button1X = this.button1X;
						button1Y = this.finalH - this.borderSize * 2;
						button2X = this.button2X;
						button2Y = button1Y;
						if(this.button2_do) button1Delay = .05;
					}else if (this.animStartDir_str == "left"){
						contentX = -this.finalW + this.borderSize * 2;
						contentY = 0;
						textX = contentX;
						textY = this.text1Y;
						if(this.button2_do){
							button1X = -this.iconW * 2 - this.spaceBetweenThumbanilIcons;
						}else{
							button1X = -this.iconW;
						}
						
						button1Y = this.buttonY;
						button2X = -this.iconW;
						button2Y = this.buttonY;
						if(this.button2_do) button2Delay = .05;
					}
					
					FWDAnimation.killTweensOf(this.contentHolder_do);	
					FWDAnimation.to(this.overlay_do, .4, {x:contentX, y:contentY});
					FWDAnimation.killTweensOf(this.text1_do);	
					FWDAnimation.to(this.text1_do, .4, {x:textX, y:textY});
					
					if(this.button1_do){
						FWDAnimation.killTweensOf(this.button1_do);
						FWDAnimation.to(this.button1_do, .7, {x:button1X, y:button1Y, alpha:0,  delay:button1Delay, ease:Expo.easeInOut});
					}
					
					if(this.button2_do){
						FWDAnimation.killTweensOf(this.button2_do);
						FWDAnimation.to(this.button2_do, .7, {x:button2X, y:button2Y, alpha:0, delay:button2Delay, ease:Expo.easeInOut});
					}
				}else{
					mainTransitionDuration = .4;
					if (self.animStartDir_str == "top"){
						newX = 0;
						newY = -self.finalH + (self.borderSize * 2);
					}else if (self.animStartDir_str == "right"){
						newX = self.finalW - (self.borderSize * 2);
						newY = 0;
					}else if (self.animStartDir_str == "bottom"){
						newX = 0;
						newY = self.finalH - (self.borderSize * 2);
					}else if (self.animStartDir_str == "left"){
						newX = -self.finalW + (self.borderSize * 2);
						newY = 0;
					}
					
					FWDAnimation.killTweensOf(self.contentHolder_do);	
					FWDAnimation.to(self.contentHolder_do, mainTransitionDuration, {x:newX, y:newY});
				}
			}else if(this.presetType_str == "curtain"){
				var finalX = this.borderSize;
				var finalY = this.borderSize;
				mainTransitionDuration = .7;
				borderTweenDuration = .7;
				borderEase_str = Circ.easeOut;
				
				this.border_do.addChild(this.contentHolder_do);
				this.resizeContent();
				
				if(this.borderSize != 0){
					FWDAnimation.to(this.fakeBorder_do.screen, borderTweenDuration, {css:{backgroundColor:this.borderNormalColor_str}, ease:borderEase_str});
				}
				
				FWDAnimation.killTweensOf(this.imageHolder_do);	
				FWDAnimation.to(this.imageHolder_do, mainTransitionDuration, {x:finalX, y:finalY, ease:Expo.easeInOut});
			}else if(this.presetType_str == "preset30" && !this.isLightboxDisabled_bl){
				mainTransitionDuration = .6;
				borderTweenDuration = .6;
				borderEase_str = Circ.easeOut;
			
				var offsetW = this.button2_do ? this.iconW + this.spaceBetweenThumbanilIcons : 0;
				var button1X = parseInt((this.finalW - this.iconW - offsetW)/2);
				var button1finalY = parseInt((this.finalH - this.iconH)/2);
				var button2X = button1X + this.iconW + this.spaceBetweenThumbanilIcons;
				var button2finalY = parseInt((this.finalH - this.iconH)/2);
				
				var button1Delay;
				var button2Delay;
				
				if (this.animStartDir_str == "top"){
					button1finalY = - this.iconH;
					if(this.button2_do){
						button2finalY = - this.iconH;
						button2Delay = .1;
					}
				}else if(this.animStartDir_str == "right"){
					button1X = this.finalW - this.borderSize;
					button1Delay = .1;
					if(this.button2_do){
						button2X = this.finalW + this.iconW + this.spaceBetweenThumbanilIcons - this.borderSize;
						button2Delay = 0;
					}
				}else if (this.animStartDir_str == "bottom"){
					button1finalY = this.finalH - this.borderSize;
					if(this.button2_do){
						button2finalY = this.finalH -  this.borderSize;
						button2Delay = .1;
					}
				}else if (this.animStartDir_str == "left"){
					button1X = -this.iconW * 2 + this.spaceBetweenThumbanilIcons;
					if(this.button2_do){
						button2X = -this.iconW;
						button2Delay = .1;
					}
				}
				this.isContentHidden_bl = false;
				if(this.button2_do) this.mainTransitionDuration += .1;
				
				FWDAnimation.killTweensOf(this.button1_do);	
				FWDAnimation.to(this.button1_do, mainTransitionDuration, {x:button1X, y:button1finalY, delay:button1Delay, ease:Expo.easeOut});
				if(this.button2_do){
					FWDAnimation.killTweensOf(this.button2_do);	
					FWDAnimation.to(this.button2_do, mainTransitionDuration, {x:button2X, y:button2finalY, delay:button2Delay, ease:Expo.easeOut});
				}
			}else if(this.presetType_str == "3d"){
				var angleX = 0;
				var angleY = 0;
				mainTransitionDuration = .8;
				borderTweenDuration = .8;
				borderEase_str = Circ.easeOut;
				
				if (this.prevAnimStartDir_str == "top"){
					angleX = 180;
					angleY = 0;
					if(this.angleX == -180){
						angleX = 180;
					}else{
						angleX = -180;
					}
				}else if (this.prevAnimStartDir_str == "right"){
					angleX = 0;
					if(this.angleY == -180){
						angleY = 180;
					}else{
						angleY = -180;
					}
				}else if (this.prevAnimStartDir_str == "bottom"){
					angleY = 0;
					if(this.angleX == -180){
						angleX = 180;
					}else if(this.angleX == 180){
						angleX = -180;
					}
				}else if (this.prevAnimStartDir_str == "left"){
					angleX = 0;
					angleY = -180;
					if(this.angleY == -180){
						angleY = 180;
					}else{
						angleY = -180;
					}
				}
				
				this.isContentHidden_bl = false;
				FWDAnimation.killTweensOf(this.main_do);	
				FWDAnimation.killTweensOf(this.contentHolder_do);
				FWDAnimation.to(this.main_do, mainTransitionDuration, {angleX:0, angleY:0, ease:Quint.easeOut});
				FWDAnimation.to(this.contentHolder_do, mainTransitionDuration, {angleX:angleX, angleY:angleY, ease:Quint.easeOut});
			}
			
			if(this.borderNormalColor_str != this.borderSelectedColor_str && this.borderSize != 0){
				FWDAnimation.to(this.border_do.screen, borderTweenDuration, {css:{borderColor:this.borderNormalColor_str}, ease:borderEase_str});
			}
			
			this.isContentShowed_bl = false;
			clearTimeout(this.contentShowCompleteId_to);
			clearTimeout(this.contentHideCompleteId_to);
			self.contentHideCompleteId_to = setTimeout(self.hideContentComplete, mainTransitionDuration * 1000);
		};
		
		this.hideContentComplete = function(){
			clearTimeout(self.contentShowCompleteId_to);
			clearTimeout(self.contentHideCompleteId_to);
			
			if(self.presetType_str != "media" 
			   && self.presetType_str != "scaletextinverse"
			){
				
				try{
					self.border_do.removeChild(self.contentHolder_do);
				}catch(e){}
				
				try{
					self.removeChild(self.contentHolder_do);
				}catch(e){}
				
				try{
					self.removeChild(self.fakeBorder_do);
				}catch(e){}
				if(self.contentHolder_do) self.contentHolder_do.setX(-1000);
			}
			
			self.isContentHidden_bl = true;
		};
		
		//##############################################//
		/* Get in or out angle */
		//##############################################//
		this.getInOrOutAngle = function(e){
			
			var viewportMouseCoordinates = FWDVRLUtils.getViewportMouseCoordinates(e);
			var globalX = self.getGlobalX();
			var globalY = self.getGlobalY();
			var screenX = viewportMouseCoordinates.screenX;
			var screenY = viewportMouseCoordinates.screenY;
			
			var dx = screenX - (globalX + self.finalW/2);
			var dy = screenY - (globalY + self.finalH/2);
			
			var angle = Math.atan2(dy, dx) * 180/Math.PI;
			
			var thumbAngle = Math.atan2(self.finalH, self.finalW) * 180/Math.PI;
			
			if ((angle < thumbAngle) && (angle > -thumbAngle))
				self.animStartDir_str = "right";
				
			if ((angle > thumbAngle) && (angle < (180 - thumbAngle)))
				self.animStartDir_str = "bottom";
				
			if ((angle < (-180 + thumbAngle)) || (angle > (180 - thumbAngle)))
				self.animStartDir_str = "left";
				
			if ((angle > (-180 + thumbAngle)) && (angle < -thumbAngle))
				self.animStartDir_str = "top";
		};
		
		//#############################################//
		/* Hide / show */
		//#############################################//
		this.hide = function(animate, overwrite){
			if(this.isHidden_bl || !this.hasImage_bl) return;
		
			var globalY = Math.abs(Math.min(0, FWDVUGP.globalY));
			var totalVisibleHeight = FWDVUGP.globalY > 0 ? FWDVUGP.viewportHeight - FWDVUGP.globalY : FWDVUGP.viewportHeight;
			
			clearTimeout(this.showHideId_to);
			this.showHideId_to = setTimeout(function(){
				self.isHidden_bl = true;
				var animate_bl = self.finalY + self.finalH > globalY && self.finalY - globalY < totalVisibleHeight;
				if(!self.isVerticalType_bl) animate_bl = true;
				
				if(self.hideAndShowTransitionType_str == "scale"){
					if(animate_bl){
						FWDAnimation.to(self, .6, {scale:0, alpha:0, delay:.05 + Math.random() * .1, ease:Quart.easeOut});
					}else{
						FWDAnimation.killTweensOf(self);
						self.setScale2(0);
						self.setAlpha(0);
					}
				}else if(self.hideAndShowTransitionType_str == "opacity"){
					if(animate_bl){
						FWDAnimation.to(self, .6, {alpha:0, delay:.05 + Math.random() * .1, ease:Quart.easeOut});
					}else{
						FWDAnimation.killTweensOf(self);
						self.setAlpha(0);
					}
				}else if(self.hideAndShowTransitionType_str == "rotation"){
					var rotation = -60 + parseInt(Math.random() * 120);
					while(rotation > -20 && rotation < 20){
						rotation = -60 + parseInt(Math.random() * 120);
					}	
					if(animate_bl){
						FWDAnimation.to(self, .6, {scale:0, rotation:rotation, delay:.05 + Math.random() * .1, ease:Quart.easeOut});
					}else{
						FWDAnimation.killTweensOf(self);
						self.setRotation(0);
						self.setScale2(0);
					}
				}else if(self.hideAndShowTransitionType_str == "none"  || FWDVRLUtils.hasTransform2d){
					self.setVisible(false);
				}
				
			}, 50);
		};
	
		this.show = function(animate){
			if(this.isVerticalType_bl){
				this.parent.addChild(this);
			}else{
				this.parent.thumbnailsHolder_do.addChild(this);
			}
			
			if(!this.isHidden_bl || !this.hasImage_bl) return;
		
			var globalY = Math.abs(Math.min(0, FWDVUGP.globalY));
			var totalVisibleHeight = FWDVUGP.globalY > 0 ? FWDVUGP.viewportHeight - FWDVUGP.globalY : FWDVUGP.viewportHeight;
			
			clearTimeout(self.contentShowCompleteId_to);
			self.isContentHidden_bl = true;
			
			clearTimeout(this.showHideId_to);
			this.showHideId_to = setTimeout(function(){
				self.isHidden_bl = false;
				
				var animate_bl = self.finalY + self.finalH > globalY && self.finalY - globalY < totalVisibleHeight;
				
				if(!self.isVerticalType_bl) animate_bl = true;
				if(self.hideAndShowTransitionType_str == "scale"){
					if(animate_bl){
						FWDAnimation.to(self, .6, {scale:1, alpha:1, delay: .05 + Math.random() * .2, ease:Quart.easeOut});
					}else{
						FWDAnimation.killTweensOf(self);
						self.setScale2(1);
						self.setAlpha(1);
					};
				}else if(self.hideAndShowTransitionType_str == "opacity"){
					if(animate_bl){
						FWDAnimation.to(self, .6, {alpha:1, delay:.05 + Math.random() * .1, ease:Quart.easeOut});
					}else{
						FWDAnimation.killTweensOf(self);
						self.setAlpha(1);
					}
				}else if(self.hideAndShowTransitionType_str == "rotation"){
					FWDAnimation.killTweensOf(self);
					if(animate_bl){
						FWDAnimation.to(self, .6, {scale:1, alpha:1, rotation:0, delay: .05 + Math.random() * .2, ease:Quart.easeOut});
					}else{
						self.setRotation(0);
						self.setScale2(1);
						self.setAlpha(1);
					};
				}else if(self.hideAndShowTransitionType_str == "none"|| FWDVRLUtils.hasTransform2d){
					self.setVisible(true);
				}
				
			}, 50);
		};
		
		this.setTransitionType = function(param_str){
			this.hideAndShowTransitionType_str = param_str;
			if(self.hideAndShowTransitionType_str == "scale"){
				if(this.isHidden_bl){
					self.setRotation(0);
					self.setAlpha(0);
					self.setScale2(0);
				}
			}else if(self.hideAndShowTransitionType_str == "rotation"){
				if(this.isHidden_bl){
					var rotation = -60 + parseInt(Math.random() * 120);
					while(rotation > -20 && rotation < 20){
						rotation = -60 + parseInt(Math.random() * 120);
					}	
					self.setRotation(rotation);
					if(this.prevAndShowTransitionType_str == "opacity"){
						self.setAlpha(0);	
					}else{
						self.setAlpha(1);
					}
					
					self.setScale2(0);
				}
			}else if(self.hideAndShowTransitionType_str == "opacity"){
				if(this.isHidden_bl){
					self.setRotation(1);
					self.setScale2(1);
					self.setAlpha(0);
				}
			}
			this.prevAndShowTransitionType_str = this.hideAndShowTransitionType_str;
		};
		
		this.setOverlayColor = function(param){
			this.overlayColor_str = param;
			this.overlay_do.setBkColor(this.overlayColor_str);
		};
		
		this.setOverlayOpacityValue = function(param){
			if(param == undefined) return
			this.overlayOpacity = param;
		};
		
		this.setOverlayOpacity = function(){
			this.overlay_do.setAlpha(this.overlayOpacity);
		};
		
		this.setContentPosition = function(param, offset, buttonsOffest){
			this.textVerticalAlign_str = param;
			this.contentOffest = offset;
			if(buttonsOffest != undefined) this.buttonsOffest = buttonsOffest; 
			
		};
		
		this.setCurtainAnimationDirection = function(param){
			self.imageTransitionDirection_str = param;
		};
		
		this.setBorderSize = function(size){
			this.borderSize = parseInt(size);
			
			if(this.borderSize == 0){
				this.border_do.getStyle().borderStyle = "none";
				this.border_do.getStyle().boxShadow = "none";
			}else{
				this.border_do.getStyle().borderStyle = "solid";
				this.border_do.getStyle().boxShadow = this.thumbanilBoxShadow_str;
			}
			
			this.border_do.getStyle().borderWidth = this.borderSize + "px";
			
		};
		
		this.setBorderRadius = function(borderRadius){
			this.borderRadius = parseInt(borderRadius);
			this.border_do.getStyle().borderRadius = this.borderRadius + "px";
			this.getStyle().borderRadius = this.borderRadius + "px";
			if(this.presetType_str == "3d") this.main_do.getStyle().borderRadius = this.borderRadius + "px";
			
		};
		
		this.setBorderColor = function(normalColor, selectedColor){
			this.borderNormalColor_str = normalColor;
			this.borderSelectedColor_str = selectedColor;
			this.border_do.getStyle().borderColor = this.borderNormalColor_str;
		};
		
		this.setBorderBoxShadow = function(param){
			this.thumbanilBoxShadow_str = param;
			if(this.presetType_str == "3d"){
				this.main_do.getStyle().boxShadow = this.thumbanilBoxShadow_str;
			}else{
				this.getStyle().boxShadow = this.thumbanilBoxShadow_str;
			}
			
			
			//if(this.thumbanilBoxShadow_str == "none" || this.thumbanilBoxShadow_str == undefined) this.getStyle().borderRadius = 0;
		};
		
		this.init();
	};
	
	
	/* set prototype */
	FWDVUGPThumbnail.setPrototype = function(){
		if(FWDVRLUtils.hasTransform2d){
			FWDVUGPThumbnail.prototype = new FWDVRLTransformDisplayObject("div");
		}else{
			FWDVUGPThumbnail.prototype = new FWDVRLDisplayObject("div");
		}
	};
	

	FWDVUGPThumbnail.MOUSE_UP = "onMouseDown";
	FWDVUGPThumbnail.RIGHT = "right";
	FWDVUGPThumbnail.LEFT = "left";
	FWDVUGPThumbnail.BOTTOM = "bottom";
	FWDVUGPThumbnail.TOP = "top";
	
	FWDVUGPThumbnail.prototype = null;
	window.FWDVUGPThumbnail = FWDVUGPThumbnail;
}(window));