/* FWDVUGPVerticalThumbnailsManager */
(function (window){
	
	var FWDVUGPVerticalThumbnailsManager = function(data, parent){
		
		var self = this;
		var prototype = FWDVUGPVerticalThumbnailsManager.prototype;
		
		this.sourcePlaylist_ar = data.playlist_ar.playlistItems;
		this.originalDataThumbnails_ar = [];
		this.dataThumbnails_ar = [];
		this.tempPlaylist_ar;
	
		this.columnHeights_ar = [];
		this.loadMoreCatsData_ar = [];
		this.catId_ar = data.startAtCategory_ar;
		
		this.loadMoreButton_do;
		
		this.curDataThumbnail;
		this.thumbnailLoadingType_str = data.thumbnailLoadingType_str;
		
		this.totalLoadedThumbnails = 0;
		this.loadMoreButtonOffsetTop = data.loadMoreButtonOffsetTop;
		this.loadMoreButtonOffsetBottom = data.loadMoreButtonOffsetBottom;
		this.thumbnailsPerSet = data.howManyThumbnailsToDisplayPerSet;
		this.thumbsHOffset = data.thumbnailsHorizontalOffset;
		this.thumbsVOffset = data.thumbnailsVerticalOffset;
		this.offsetTotalHeight = 0;
		this.maxH = 0;
		this.thumbOffsetX = 0;
		this.catId = data.startAtCategory;
		this.stageWidth = 0;
		this.prevStageWidth = 0;
		this.thumbnailMaxWidth = data.thumbnailMaxWidth;
		this.thumbnailMaxHeight = data.thumbnailMaxHeight;
		this.leftWidth = 0;
		this.thumbWidth;
		this.thumbHeight;
		this.thumbsHSpace = data.horizontalSpaceBetweenThumbnails;
		this.thumbsVSpace = data.verticalSpaceBetweenThumbnails;
		this.countLoadedThumbs = 0;
		this.borderSize = data.thumbnailBorderSize;
		this.totalThumbnails = this.sourcePlaylist_ar.length;
		this.tempTotalThumbnails = this.sourcePlaylist_ar.length;
		this.totalOriginalThumbnails = this.sourcePlaylist_ar.length;
		this.globalX = 0;
		this.globalY = 0;
		
		this.searchValue = "";
		
		this.catChanging_to;
		this.arangeFaterTweenId_to;
		this.updateSearch_to;
		
		this.centerWithMenu_bl = data.centerNoSearchFoundLabelWithMenu_bl;
		this.isLoadAtTheEnd_bl = false;
		this.isLoadMoreButtonShowed_bl = true;
		this.isCatChanging_bl = false;
		this.isFirstThumbnailLoaded_bl = false;
		this.firstThumbnailShowed_bl = false;
		this.animateParent_bl = data.animateParent_bl;
		
		this.showAllCategories_bl = data.showAllCategories_bl;
		this.totalCats = this.showAllCategories_bl ? data.categories_ar.length-1 : data.categories_ar.length;
		
		this.isMobile_bl = FWDVRLUtils.isMobile;
		
		
		//#######################################//
		/* initialize */
		//#######################################//
		this.init = function(){
			this.setOverflow("visible");
			this.setBkColor(parent.backgroundColor_str);
			this.setupThumbnailsData();
			if(self.thumbnailLoadingType_str == "loadmorewithbutton"){
				this.setupLoadMoreButton();
			}else if(this.thumbnailLoadingType_str == "loadmoreonscroll"){
				this.setupLoadMoreOnScroll();
			}
		
			this.filterCategories();
			this.startGetMousePosition();
			this.setupNoSearch();
		};
		
		//#######################################//
		/* Position and resize */
		//#######################################//
		this.resizeAndPosition = function(){
			self.stageWidth = parent.stageWidth;
			self.setDataForResize();
			self.positionThumbnailsAndMain();
		};
		
		//#######################################//
		/* Get mouse position */
		//#######################################//
		this.startGetMousePosition = function(){
			if(window.addEventListener){
				if(!self.isMobile_bl){
					window.addEventListener("touchstart", this.getMousePosition);
				}
				window.addEventListener("mousemove", this.getMousePosition);
			}else if(document.attachEvent){
				document.attachEvent("onmousemove", this.getMousePosition);
			}
		};
		
		this.getMousePosition = function(e){
			var mc = FWDVRLUtils.getViewportMouseCoordinates(e);
			if(!self.isMobile_bl){
				self.globalX = mc.screenX;
				self.globalY = mc.screenY;
			}
		};
		
		//#######################################//
		/* Setup thumbnails data */
		//#######################################//
		this.setupThumbnailsData = function(){
			var catsLength_ar = [];
			var obj;
			
			for (var i=0; i<this.totalThumbnails; i++){
				obj = {};
				obj.thumbnail = undefined;
				obj.id = i;
				obj.catId = this.sourcePlaylist_ar[i].catId;
				this.originalDataThumbnails_ar[i] = obj;
				this.dataThumbnails_ar[i] = obj;
			}
			
			for (var i=0; i<this.totalCats; i++){
				catsLength_ar[i] = 0;
			}
			
			for (var i=0; i< this.totalThumbnails; i++){
				catsLength_ar[this.dataThumbnails_ar[i].catId]++;
			}

			
			for (var i=0; i<this.totalCats; i++){
				obj = {};
				obj.loaded = 0;
				obj.limit = 0;
				obj.total = catsLength_ar[i];
				obj.isSelected = false;
				
				this.loadMoreCatsData_ar[i] = obj;
			}
		};
		
		//################################################//
		/* search */
		//################################################//
		this.search = function(searchValue){
			self.searchValue = searchValue;
			
			clearTimeout(self.updateSearch_to);
			self.updateSearch_to = setTimeout(function(){self.filterCategories();}, 200);
		};
	
		//#######################################//
		/* Setup thumbnails */
		//#######################################//
		this.getThumbnail =  function(catId, id){
			
			var props_obj = {};
			
			props_obj.parent = this;
			props_obj.id = id;
			props_obj.catId = catId;
			props_obj.presetType_str = data.presetType_str;
			props_obj.backgroundColor_str = data.thumbnailBackgroundColor_str;
			props_obj.borderNormalColor_str = this.sourcePlaylist_ar[id].thumbnailBorderNormalColor || data.thumbnailBorderNormalColor_str;
			props_obj.borderSelectedColor_str = this.sourcePlaylist_ar[id].thumbnailBorderSelectedColor || data.thumbnailBorderSelectedColor_str;
			props_obj.borderSize = data.thumbnailBorderSize;
			props_obj.borderRadius = data.thumbnailBorderRadius;
			props_obj.thumbnailOverlayColor_str = this.sourcePlaylist_ar[id].thumbnailOverlayColor || data.thumbnailOverlayColor_str;
			props_obj.thumbnailOverlayOpacity = data.thumbnailOverlayOpacity;
			props_obj.spaceBetweenTextAndIcons = data.spaceBetweenTextAndIcons;
			props_obj.extraButtonUrl_str = this.sourcePlaylist_ar[id].extraButtonUrl_str;
			props_obj.extraButtonUrlTarget_str = this.sourcePlaylist_ar[id].extraButtonUrlTarget_str;
			props_obj.thumbIconPathN_str = this.sourcePlaylist_ar[id].thumbIconPathN_str; 
			props_obj.thumbIconPathS_str = this.sourcePlaylist_ar[id].thumbIconPathS_str; 
			props_obj.thumbnailIconWidth = data.thumbnailIconWidth;
			props_obj.thumbnailIconHeight = data.thumbnailIconHeight;
			props_obj.linkIconPathN_str = data.linkIconPathN_str;
			props_obj.linkIconPathS_str = data.linkIconPathS_str;
			props_obj.spaceBetweenThumbanilIcons = data.spaceBetweenThumbanilIcons;
			props_obj.hideAndShowTransitionType_str = data.hideAndShowTransitionType_str;
			props_obj.textVerticalAlign_str = data.textVerticalAlign_str;
			props_obj.imageTransitionDirection_str = data.imageTransitionDirection_str;
			props_obj.thumbanilBoxShadow_str = data.thumbanilBoxShadow_str;
			props_obj.textAnimType_str = data.textAnimType_str;
			props_obj.disableThumbnails_bl = data.disableThumbnails_bl;
			props_obj.useIconButtons_bl = data.useIconButtons_bl;
			props_obj.alt_str = this.sourcePlaylist_ar[id].alt_str;
			props_obj.linkUrl_str = this.sourcePlaylist_ar[id].url;
			props_obj.linkTarget_str = this.sourcePlaylist_ar[id].target;
			props_obj.contentOffsetY = data.contentOffsetY;
			props_obj.buttonsOffest = data.buttonsOffestY;
			props_obj.isVerticalType_bl = data.isVerticalType_bl;
			props_obj.isDisabled_bl = this.sourcePlaylist_ar[id].disabled_bl;
			props_obj.htmlContent1_str = this.sourcePlaylist_ar[id].htmlContent1_str;
			props_obj.htmlContent2_str = this.sourcePlaylist_ar[id].htmlContent2_str;
			
			FWDVUGPThumbnail.setPrototype();
			thumbnail = new FWDVUGPThumbnail(props_obj);
			thumbnail.addListener(FWDVUGPThumbnail.MOUSE_UP, this.thumbanilOnMouseUpHandler);
			
			this.addChild(thumbnail);
			return thumbnail;
		};
		
		this.thumbanilOnMouseUpHandler = function(e){
			
			var regularId = e.id;
			var tempId = e.id;
			
			var type = e.extraButton ? "extraButtonLink" : self.sourcePlaylist_ar[regularId].type_str;
			
			for(var i=0; i<self.totalOriginalThumbnails; i++){
				if(i < tempId  && (self.sourcePlaylist_ar[i].type_str == FWDVUGP.NONE || self.sourcePlaylist_ar[i].type_str == FWDVUGP.LINK)){
					regularId -= 1;
				}
			};
			
			if(type == "extraButtonLink"){
				if(data.isPintrest_bl){
					PDK.pin(self.sourcePlaylist_ar[e.id].thumbnailPath_str, 
							self.sourcePlaylist_ar[e.id].rawDescription_str, 
							self.sourcePlaylist_ar[e.id].pinLInk_str, 
					 function(){});
				}else{
					window.open(self.dataThumbnails_ar[e.id].thumbnail.extraButtonUrl_str, self.dataThumbnails_ar[e.id].thumbnail.extraButtonUrlTarget_str);
				}
			}else if(type == "link"){
				window.open(self.dataThumbnails_ar[e.id].thumbnail.linkUrl_str, self.dataThumbnails_ar[e.id].thumbnail.linkTarget_str);
			}else{
				self.dispatchEvent(FWDVUGPVerticalThumbnailsManager.OPEN_LIGHTBOX, {id:regularId});
			}
			
		};
		
		//###############################################//
		/* Update category */
		//###############################################//
		this.updateCategory =  function(catId_ar){
			if(this.catId_ar == catId_ar) return;
			this.catId_ar = catId_ar;
			
			this.filterCategories();
			this.positionThumbnailsAndMain();
			
			this.dispatchEvent(FWDVUGPVerticalThumbnailsManager.CATEGORY_UPDATE);
		};
		
		//###############################################//
		/* Load thumbnails */
		//###############################################//
		this.stopToLoadImage = function(){
			clearTimeout(this.loadThumbnailId_to);
			if (self.image_img){
				self.image_img.onerror = null;
				self.image_img.onload = null;
				//self.image_img.src = "";
			}
		};
		
		this.startToLoadImage = function(imagePath){
			self.image_img = new Image();
			self.image_img.onerror = self.onImageLoadErrorHandler;
			self.image_img.onload = self.onImageLoadHandler;
			self.image_img.src = imagePath;
		};
		
		this.loadThumbImage = function(){
			var dataThumbnail;
			var curLoadCatId;
			
			self.stopToLoadImage();
		
			for (var i=0; i<self.totalCats; i++){
				if(self.loadMoreCatsData_ar[i].isSelected && (self.loadMoreCatsData_ar[i].loaded < self.loadMoreCatsData_ar[i].limit)){
					curLoadCatId = i;
					break;
				}
			}
			
			for (var i=0; i<self.tempTotalThumbnails; i++){
				self.curDataThumbnail = self.tempPlaylist_ar[i];
				if (self.curDataThumbnail.catId == curLoadCatId && !self.curDataThumbnail.thumbnail) break;
			}
			
			self.startToLoadImage(self.sourcePlaylist_ar[self.curDataThumbnail.id].thumbnailPath_str);	
		};

		this.onImageLoadErrorHandler = function(e){
			var message = "Thumbnail image can't be loaded, probably the path is incorrect <font color='#FFFFFF'>"
					+ self.sourcePlaylist_ar[self.curDataThumbnail.id].thumbnailPath_str + "</font>";
			self.dispatchEvent(FWDVUGPVerticalThumbnailsManager.ERROR, {text : message});
		};

		this.onImageLoadHandler = function(e){
			
			var curThumbnail_do = self.getThumbnail(self.curDataThumbnail.catId, self.curDataThumbnail.id);
			
			self.loadMoreCatsData_ar[self.curDataThumbnail.catId].loaded++;
			
			self.curDataThumbnail.thumbnail = curThumbnail_do;
			self.originalDataThumbnails_ar[self.curDataThumbnail.id].thumbnail = curThumbnail_do;
			
			curThumbnail_do.hasImg_bl = true;
			curThumbnail_do.originalWidth = self.image_img.width;
			curThumbnail_do.originalHeight = self.image_img.height;
			curThumbnail_do.addImage(self.image_img);
			
			self.countLoadedThumbs ++;
			if(!self.isFirstThumbnailLoaded_bl){
				setTimeout(function(){
					self.firstThumbnailShowed_bl = true;
				}, 200);
			}
			
			self.updateCurThumbnails();
			self.positionThumbnailsAndMain();
		};
		
		//###########################################//
		/* Update load more categories limits */
		//###########################################//
		this.updateCatsLimits = function(){
		
			var thumbsToAdd = self.thumbnailsPerSet;
			var catId = 0;
			
			if(this.showAllCategories_bl && this.catId_ar[0] == 0){
				if(this.loadMoreCatsData_ar[0].limit == 0){
					while((thumbsToAdd > 0) && (catId < this.totalCats)){
						if(this.loadMoreCatsData_ar[catId].limit + thumbsToAdd > this.loadMoreCatsData_ar[catId].total){
							thumbsToAdd -= this.loadMoreCatsData_ar[catId].total - this.loadMoreCatsData_ar[catId].limit;
							this.loadMoreCatsData_ar[catId].limit = this.loadMoreCatsData_ar[catId].total;
						}else{
							this.loadMoreCatsData_ar[catId].limit += thumbsToAdd;
							thumbsToAdd = 0;
						}
						
						catId++;
					}
				}
			}else{
				for (var i=0; i<this.totalCats; i++){
					if(this.loadMoreCatsData_ar[i].isSelected && this.loadMoreCatsData_ar[i].limit < this.thumbnailsPerSet){
						this.loadMoreCatsData_ar[i].limit = Math.min(this.loadMoreCatsData_ar[i].total, this.thumbnailsPerSet);
					}
				}
			}
			
			
			this.totalThumbnailsLimit = 0;
			
			for(var i=0; i<this.totalCats; i++){
				if (this.loadMoreCatsData_ar[i].isSelected){
					this.totalThumbnailsLimit += this.loadMoreCatsData_ar[i].limit;
				}
			}
		};
		
		//#################################################//
		/* Get allow to load more thumbnails */
		//#################################################//
		this.allowToLoadMoreThumbnails = function(){
			if((this.totalLoadedThumbnails == this.totalThumbnailsLimit) && (this.totalLoadedThumbnails < this.tempTotalThumbnails)){
				return true;
			}else{
				return false;
			}
		};
		
		//################################################//
		/* Load more thumbnails */
		//################################################//
		this.loadMore = function(){
			var thumbsToAdd = self.thumbnailsPerSet;
			var catId = 0;
			
			while((thumbsToAdd > 0) && (catId < self.totalCats)){
				if(self.loadMoreCatsData_ar[catId].isSelected){
					if(self.loadMoreCatsData_ar[catId].limit + thumbsToAdd > self.loadMoreCatsData_ar[catId].total){
						thumbsToAdd -= self.loadMoreCatsData_ar[catId].total - self.loadMoreCatsData_ar[catId].limit;
						self.loadMoreCatsData_ar[catId].limit = self.loadMoreCatsData_ar[catId].total;
					}else{
						self.loadMoreCatsData_ar[catId].limit += thumbsToAdd;
						thumbsToAdd = 0;
					}
				}
				
				catId++;
			}
		
			this.totalThumbnailsLimit = 0;
			
			for(var i=0; i<this.totalCats; i++){
				if (this.loadMoreCatsData_ar[i].isSelected){
					this.totalThumbnailsLimit += this.loadMoreCatsData_ar[i].limit;
				}
			}
			
			self.loadThumbImage();
		};
		
		//######################################//
		/* Update categories data (for SEARCH) */
		//######################################//
		this.updateCatsData = function()
		{
			var catsLength_ar = [];
			var catsLoaded_ar = [];
			var dataThumbnail;
			var obj;
			
			self.loadMoreCatsData_ar = [];
			
			for (var i=0; i<self.totalCats; i++)
			{
				catsLength_ar[i] = 0;
				catsLoaded_ar[i] = 0;
			}
			
			for (var i=0; i< self.totalThumbnails; i++)
			{
				dataThumbnail = self.dataThumbnails_ar[i];
				
				catsLength_ar[dataThumbnail.catId]++;
				
				if (dataThumbnail.thumbnail)
				{
					catsLoaded_ar[dataThumbnail.catId]++;
				}
			}
			
			for (var i=0; i<self.totalCats; i++)
			{
				obj = {};
				obj.loaded = catsLoaded_ar[i];
				obj.limit = catsLoaded_ar[i];
				obj.total = catsLength_ar[i];
				obj.isSelected = false;
				
				self.loadMoreCatsData_ar[i] = obj;
			}
		};
		
		//####################################//
		/* Filter categories */
		//###################################//
		this.filterCategories = function()
		{
			var dataThumbnail;
			var offsetCatId = 0;
			var hasCorrectId_bl;
			
			this.tempPlaylist_ar = [];
			this.playlist_ar = [];
			this.dataThumbnails_ar = [];
			
			self.stopToLoadImage();
			
			for (var i=0; i<self.sourcePlaylist_ar.length; i++)
			{
				dataThumbnail = self.originalDataThumbnails_ar[i];
				
				if (self.sourcePlaylist_ar[i].titleText_str && self.sourcePlaylist_ar[i].titleText_str.toLowerCase().indexOf(self.searchValue) != -1)
				{
					self.dataThumbnails_ar.push(dataThumbnail);
				}
				else
				{
					if (dataThumbnail.thumbnail)
					{
						dataThumbnail.thumbnail.hide(true);
					}
				}
			}
			
			self.totalThumbnails = self.dataThumbnails_ar.length;
			
			this.updateCatsData();
			
			if(this.showAllCategories_bl) offsetCatId = 1;
			
			if(this.showAllCategories_bl && self.catId_ar[0] == 0){
				for (i=0; i<this.totalThumbnails; i++){
					dataThumbnail = this.dataThumbnails_ar[i];
					this.tempPlaylist_ar.push(dataThumbnail);
					
					if (dataThumbnail.thumbnail){
						this.playlist_ar.push(dataThumbnail);
						dataThumbnail.thumbnail.show(true);
					}
				}
				
				for (var i=0; i<this.totalCats; i++){
					this.loadMoreCatsData_ar[i].isSelected = true;
				}
			}else{
				for (i=0; i<this.totalThumbnails; i++){
					dataThumbnail = this.dataThumbnails_ar[i];
					hasCorrectId_bl = false;
					
					for (var j=0; j<this.totalCats; j++){
						if (dataThumbnail.catId == self.catId_ar[j] - offsetCatId){
							this.tempPlaylist_ar.push(dataThumbnail);
							
							if (dataThumbnail.thumbnail){
								this.playlist_ar.push(dataThumbnail);
							}
							
							this.loadMoreCatsData_ar[self.catId_ar[j] - offsetCatId].isSelected = true;
							
							hasCorrectId_bl = true;
						}
					}
					
					if(hasCorrectId_bl){
						if(dataThumbnail.thumbnail) dataThumbnail.thumbnail.show(true);
					}else{
						if(dataThumbnail.thumbnail) dataThumbnail.thumbnail.hide(true);
					}
				}
			}
			
			this.tempTotalThumbnails = this.tempPlaylist_ar.length;
			this.totalLoadedThumbnails = this.playlist_ar.length;
			
			if (this.tempTotalThumbnails == 0)
			{
				this.hasSearchResult_bl = false;
				this.showNoSearch();
				
			}else{
				this.hasSearchResult_bl = true;
				this.hideNoSearch();
			}
			
			this.updateCatsLimits();
			
			if(this.totalLoadedThumbnails < this.totalThumbnailsLimit)
			{
				clearTimeout(this.loadThumbnailId_to);
				this.loadThumbnailId_to = setTimeout(this.loadThumbImage, 300);
			}
			else
			{
				self.updateCurThumbnails();
				self.positionThumbnailsAndMain();
			}
			
			if(self.thumbnailLoadingType_str == "loadmorewithbutton")
			{ 
				this.hideOrShowLoadMoreButton();
			}
		};
		
		//######################################//
		/* Update thumbnails */
		//######################################//
		this.updateCurThumbnails = function(){
			var dataThumbnail;
			var offsetCatId = 0;
			
			this.playlist_ar = [];
			
			if(this.showAllCategories_bl) offsetCatId = 1;
			
			if (this.showAllCategories_bl && self.catId_ar[0] == 0){
				for (i=0; i<this.totalThumbnails; i++){
					dataThumbnail = this.dataThumbnails_ar[i];
					
					if (dataThumbnail.thumbnail){
						this.playlist_ar.push(dataThumbnail);	
					}
				}
			}else{
				for (i=0; i<this.totalThumbnails; i++){
					dataThumbnail = this.dataThumbnails_ar[i];
					
					for (var j=0; j<this.totalCats; j++){
						if (dataThumbnail.catId == self.catId_ar[j] - offsetCatId){
							if (dataThumbnail.thumbnail){
								this.playlist_ar.push(dataThumbnail);
							}
						}
					}
				}
			}
			
			this.totalLoadedThumbnails = this.playlist_ar.length;
			
			if (this.totalLoadedThumbnails < this.totalThumbnailsLimit){
				clearTimeout(this.loadThumbnailId_to);
				this.loadThumbnailId_to =  setTimeout(this.loadThumbImage, 10);
			}
			
			if(self.thumbnailLoadingType_str == "loadmorewithbutton"){ 
				this.hideOrShowLoadMoreButton();
			}else if(this.thumbnailLoadingType_str == "loadmoreonscroll"){
				this.loadInfinite();
			}
		};
		
		//###############################################//
		/* set data for thumbnail resize */
		//###############################################//
		this.setDataForResize = function()
		{
			if(!this.stageWidth) return;
			
			this.totalColumns = Math.ceil((this.stageWidth - this.thumbsHOffset * 2 + this.thumbsHSpace) / (this.thumbnailMaxWidth + this.borderSize * 2 + this.thumbsHSpace));
			
			this.thumbWidth = Math.floor((this.stageWidth - this.thumbsHOffset * 2 + this.thumbsHSpace - this.totalColumns * (this.thumbsHSpace + this.borderSize * 2)) / this.totalColumns);
			this.thumbHeight = Math.floor(this.thumbWidth * (this.thumbnailMaxHeight / this.thumbnailMaxWidth));
		
			var totalWidth = this.totalColumns * (this.thumbWidth + this.borderSize * 2 + this.thumbsHSpace) - this.thumbsHSpace;
			
			this.leftWidth = this.stageWidth - this.thumbsHOffset * 2 - totalWidth;
			
			this.prevStageWidth = this.stageWidth;
		};
		
		//#############################################//
		/* Position and resize main thumbnails and main div's */
		//##############################################//
		this.positionThumbnailsAndMain = function()
		{
			this.columnHeights_ar = [];
			
			for (var i=0; i<this.totalColumns; i++)
			{
				this.columnHeights_ar[i] = 0;
			}
			
			for (var i=0; i<this.totalLoadedThumbnails; i++)
			{
				thumbnail = this.playlist_ar[i].thumbnail;
				thumbnail.used_bl = false;
			}
		
			// first positioning iteration
			this.positionThumbnails();
			
			// second positioning iteration - for any remaining thumbs that didn't fit the first time
			this.positionThumbnails();
			
			// last positioning iteration - for the last remaining high-width thumbs
			this.positionThumbnails2();
			
			this.totalHeight = Math.max(0, this.maxH * (this.thumbHeight + this.thumbsVSpace + this.borderSize * 2) - this.thumbsVSpace + this.thumbsVOffset * 2);
			
			if(!self.hasSearchResult_bl){
				self.totalHeight = self.thumbHeight;
				self.positionNoSearchLabel();
			}
			
			this.positionLoadMoreButton();
			this.totalHeight += this.offsetTotalHeight;
			
			this.setWidth(this.stageWidth);
			
			if(this.prevTotalHeight != this.totalHeight){
				if(this.firstThumbnailShowed_bl && this.animateParent_bl && !this.isMobile_bl){
					FWDAnimation.to(this, .7, {h:this.totalHeight, ease:Quart.easeOut});
					clearTimeout(this.arangeFaterTweenId_to);
					this.arangeFaterTweenId_to = setTimeout(function(){
						if(self.stageWidth !=  parent.stageContainer.offsetWidth){
							parent.onResizeHandler();
						}
					}, 700);
					
				}else{
					this.setHeight(this.totalHeight);
				}
			}
			
			parent.setFinalSize();
			
			parent.stageWidth = parent.stageContainer.offsetWidth;
			this.prevTotalHeight = this.totalHeight;
			
			if(self.stageWidth != parent.stageWidth){
				parent.onResizeHandler();
			}
		};
		
		//###############################################//
		/* position thumbmails */
		//###############################################//
		this.positionThumbnails = function()
		{
			var minH;
			var minHVal;
			var wSize;
			var hSize;
			var found_bl;
			var fPlace;
			var tempFinalX;
			var tempFinalY;
			var tempFinalW;
			var tempFinalH;
			var thumbnail;
			var finalW_ar = [];
			var finalX_ar = [];
			
			for (var i=0; i<self.totalColumns; i++)
			{
				finalW_ar[i] = self.thumbWidth + self.borderSize * 2;
				
				if ((self.leftWidth > 0) && (i < self.leftWidth))
				{
					finalW_ar[i]++;
				}
				
				if (i == 0)
				{
					finalX_ar[i] = self.thumbsHOffset;
				}
				else
				{
					finalX_ar[i] = finalX_ar[i - 1] + finalW_ar[i - 1] + self.thumbsHSpace;
				}
			}
			
			for (var i=0; i<self.totalLoadedThumbnails; i++)
			{
				thumbnail = self.playlist_ar[i].thumbnail;
				
				if (thumbnail.used_bl) continue;
				
				wSize = Math.round(thumbnail.originalWidth / self.thumbnailMaxWidth);
				hSize = Math.round(thumbnail.originalHeight / self.thumbnailMaxHeight);
				
				minHVal = 1000;
				
				if (wSize == 1)
				{
					thumbnail.used_bl = true;
					
					for (var j=0; j<self.totalColumns; j++)
					{
						if (self.columnHeights_ar[j] < minHVal)
						{
							minHVal = self.columnHeights_ar[j];
						}
					}
					
					for (var j=0; j<self.totalColumns; j++)
					{
						if (self.columnHeights_ar[j] == minHVal)
						{
							minH = j;
							
							break;
						}
					}
					
					tempFinalX = finalX_ar[minH];
					tempFinalY = self.columnHeights_ar[minH] * (self.thumbHeight + self.thumbsVSpace + self.borderSize * 2) + self.thumbsVOffset;
					
					tempFinalW = finalW_ar[minH];
					tempFinalH = (self.thumbHeight + self.thumbsVSpace + self.borderSize * 2) * hSize - self.thumbsVSpace;
					
					thumbnail.finalW = tempFinalW;
					thumbnail.finalH = tempFinalH;
					
					thumbnail.finalX = tempFinalX;
					thumbnail.finalY = tempFinalY;
				
					thumbnail.resizeAndPosition();
					
					self.columnHeights_ar[minH] += hSize;
				}
				else
				{
					found_bl = false;
					
					for (var j=0; j<self.totalColumns - (wSize-1); j++)
					{
						fPlace = true;
						
						for (var k=0; k<wSize; k++)
						{
							if (self.columnHeights_ar[j] != self.columnHeights_ar[j+k]) fPlace = false;
						}
						
						if (fPlace && (self.columnHeights_ar[j] < minHVal))
						{
							minHVal = self.columnHeights_ar[j];
							minH = j;
							
							found_bl = true;
						}
					}
					
					if (found_bl)
					{	
						thumbnail.used_bl = true;
						
						tempFinalX = finalX_ar[minH];
						tempFinalY = self.columnHeights_ar[minH] * (self.thumbHeight + self.thumbsVSpace + self.borderSize * 2) + self.thumbsVOffset;
						
						tempFinalW = -self.thumbsHSpace;
						for (var k=0; k<wSize; k++)
						{
							tempFinalW += finalW_ar[minH + k] + self.thumbsHSpace;
						}
						
						tempFinalH = (self.thumbHeight + self.thumbsVSpace + self.borderSize * 2) * hSize - self.thumbsVSpace;
						
						thumbnail.finalW = tempFinalW;
						thumbnail.finalH = tempFinalH;
						
						thumbnail.finalX = tempFinalX;
						thumbnail.finalY = tempFinalY;
						
						thumbnail.resizeAndPosition();
						
						for (var k=0; k<wSize; k++)
						{
							self.columnHeights_ar[minH + k] += hSize;
						}
					}
				}
			}
			
			self.maxH = 0;
			
			for (var i=0; i<self.totalColumns; i++)
			{
				if (self.columnHeights_ar[i] > self.maxH)
				{
					self.maxH = self.columnHeights_ar[i];
				}
			}
		};
		
		//###############################################//
		/* position thumbnails at the bottom if they don't have a place in grid */
		//###############################################//
		this.positionThumbnails2 = function()
		{
			var tempFinalX;
			var tempFinalY;
			var tempFinalW;
			var tempFinalH;
			var finalW_ar = [];
			
			for (var i=0; i<self.totalColumns; i++)
			{
				finalW_ar[i] = self.thumbWidth + self.borderSize * 2;
				
				if ((self.leftWidth > 0) && (i < self.leftWidth))
				{
					finalW_ar[i]++;
				}
			}
			
			this.maxH = 0;
			
			for (var i=0; i<this.totalColumns; i++)
			{
				if (this.columnHeights_ar[i] > this.maxH)
				{
					this.maxH = this.columnHeights_ar[i];
				}
			}
			
			for (var i=0; i<this.totalLoadedThumbnails; i++)
			{
				thumbnail = this.playlist_ar[i].thumbnail;
				
				if (thumbnail.used_bl) continue;
				
				thumbnail.used_bl = true;
			
				var wSize = Math.round(thumbnail.originalWidth / this.thumbnailMaxWidth);	
				var hSize = Math.round(thumbnail.originalHeight / this.thumbnailMaxHeight);
				
				if (this.totalColumns < wSize)
				{
					wSize = this.totalColumns;
				}
				
				tempFinalX = this.thumbsHOffset;
				tempFinalY = this.maxH * (this.thumbHeight + this.thumbsVSpace + this.borderSize * 2) + this.thumbsVOffset;
				
				tempFinalW = -self.thumbsHSpace;
				for (var k=0; k<wSize; k++)
				{
					tempFinalW += finalW_ar[k] + self.thumbsHSpace;
				}
						
				tempFinalH = (this.thumbHeight + this.thumbsVSpace + this.borderSize * 2) * hSize - this.thumbsVSpace;
				
				thumbnail.finalX = tempFinalX;
				thumbnail.finalY = tempFinalY;
				
				thumbnail.finalW = tempFinalW;
				thumbnail.finalH = tempFinalH;
				
				thumbnail.resizeAndPosition();
				
				this.maxH += hSize;
				
				for (var k=0; k<wSize; k++)
				{
					this.columnHeights_ar[k] = this.maxH;
				}
			}
		};
		
		//####################################//
		/* Setup no search found */
		//####################################//
		this.setupNoSearch = function(){
			
			this.noSearch_do =  new FWDVRLDisplayObject("div");
			this.noSearch_do.setOverflow("visible");
			this.noSearch_do.setDisplay("inline-block");
			this.noSearch_do.getStyle().fontSmoothing = "antialiased";
			this.noSearch_do.getStyle().webkitFontSmoothing = "antialiased";
			this.noSearch_do.getStyle().textRendering = "optimizeLegibility";
			this.noSearch_do.getStyle().whiteSpace = "nowrap";
			this.noSearch_do.setBackfaceVisibility();
			this.noSearch_do.getStyle().padding = "";
			this.noSearch_do.getStyle().margin = "";
			this.noSearch_do.screen.className = data.searchNotFoundClassName_str; 
			this.noSearch_do.hasTransform3d_bl =  false;
			this.noSearch_do.hasTransform2d_bl =  false;
			this.noSearch_do.setAlpha(0);
			this.noSearch_do.setInnerHTML(data.searchNotFoundLabel_str);
			
		
			this.addChild(this.noSearch_do);
			setTimeout(function(){
				self.noSearch_do.w = self.noSearch_do.getWidth();
				self.noSearch_do.h = self.noSearch_do.getHeight();
				self.removeChild(self.noSearch_do);
			}, 70);
		};
		
		this.showNoSearch = function(){
			if(this.isNoSearchFoundShowed_bl) return;
			this.isNoSearchFoundShowed_bl = true;
			this.addChild(this.noSearch_do);
			this.positionNoSearchLabel();
			FWDAnimation.killTweensOf(this.noSearch_do);
			FWDAnimation.to(this.noSearch_do, .1, {alpha:1, yoyo:true, repeat:8});
			
		};
		
		this.hideNoSearch = function(){
			if(!this.isNoSearchFoundShowed_bl) return;
			this.isNoSearchFoundShowed_bl = false;
			FWDAnimation.killTweensOf(this.noSearch_do);
			FWDAnimation.to(this.noSearch_do, .1, {alpha:0, onComplete:function(){
				self.removeChild(self.noSearch_do);
			}});
			
		};
		
		this.positionNoSearchLabel = function(){
			if(!this.isNoSearchFoundShowed_bl) return;
			this.noSearch_do.setX(parseInt((this.stageWidth - this.noSearch_do.w)/2));
			if(parent.menu_do.isShowed_bl && this.centerWithMenu_bl){		
				this.noSearch_do.setY(parseInt((this.totalHeight - parent.menu_do.menuOffsetBottom - this.noSearch_do.h)/2));
			}else{
				this.noSearch_do.setY(parseInt((this.totalHeight - this.noSearch_do.h)/2));
			}
			
		};
		
		//##########################################//
		/* Setup load more button */
		//##########################################//
		this.setupLoadMoreButton = function(){
			
			FWDVUGPMenuButton.setPrototype();
			self.loadMoreButton_do = new FWDVUGPMenuButton(
				data.loadMoreButtonLabel_str,
				data.loadMoreButtonBackgroundNormalClassName_str,
				data.loadMoreButtonBackgroundSelectedClassName_str,
				data.loadMoreButtonTextNormalClassName_str,
				data.loadMoreButtonTextSeectedClassName_str
			);
			
			this.loadMoreButton_do.setLabel(data.loadMoreButtonLabel_str);
			this.loadMoreButton_do.getStyle().zIndex = 20;
			this.loadMoreButton_do.addListener(FWDVUGPMenuButton.MOUSE_UP, this.loadMoreButtonOnMouseUpHandler);
			this.hideLoadMoreButton();
			this.addChild(this.loadMoreButton_do);
		};
		
		this.loadMoreButtonOnMouseUpHandler = function(){
			self.hideLoadMoreButton();
			self.loadMore();
		};
		
		this.hideLoadMoreButton = function(){
			if(!this.loadMoreButton_do || !this.isLoadMoreButtonShowed_bl) return;
			this.isLoadMoreButtonShowed_bl = false;
			this.loadMoreButton_do.setVisible(false);
		};
		
		this.showLoadMoreButton = function(){
			if(!this.loadMoreButton_do || this.isLoadMoreButtonShowed_bl) return;
			this.isLoadMoreButtonShowed_bl = true;
			this.loadMoreButton_do.setVisible(true);
			if(!this.isMobile_bl){
				this.loadMoreButton_do.setAlpha(0);
				FWDAnimation.to(this.loadMoreButton_do, .6, {alpha:1});
			}
			this.positionLoadMoreButton();
		};
		
		this.hideOrShowLoadMoreButton = function(){
			if (self.allowToLoadMoreThumbnails()){
				self.showLoadMoreButton();
			}else{
				self.hideLoadMoreButton();
			}
		};
		
		this.positionLoadMoreButton = function(){
			if(!this.isLoadMoreButtonShowed_bl || !this.loadMoreButton_do){
				this.offsetTotalHeight = 0;
				return;
			}
			
			if(this.isMobile_bl || this.loadMoreButton_do.alpha == 0){
				this.loadMoreButton_do.setX(parseInt((this.stageWidth - this.loadMoreButton_do.w)/2));
				this.loadMoreButton_do.setY(this.totalHeight + this.loadMoreButtonOffsetTop);
			}else{
				FWDAnimation.to(this.loadMoreButton_do, .5, 
					{x:parseInt((this.stageWidth - this.loadMoreButton_do.w)/2),
					y:parseInt((this.totalHeight + this.loadMoreButtonOffsetTop))
				});
			}
			
			
			this.offsetTotalHeight = this.loadMoreButtonOffsetTop + this.loadMoreButtonOffsetBottom + this.loadMoreButton_do.h;
			
		};
		
		//######################################//
		/* Infinite scroll */
		//######################################//
		this.setupLoadMoreOnScroll = function(){
			if(window.addEventListener){
				window.addEventListener("scroll", this.onScrollHandler);
			}else if(window.attachEvent){
				window.attachEvent("onscroll", this.onScrollHandler);
			}
		};
		
		this.onScrollHandler = function(){
			self.loadInfinite();
			if(self.totalLoadedThumbnails == self.totalThumbnails){
				if(window.removeEventListener){
					window.removeEventListener("scroll", this.onScrollHandler);
				}else if(window.detachEvent){
					window.detachEvent("onscroll", this.onScrollHandler);
				}
			}
		};
		
		this.loadInfinite = function(){
			if(!this.allowToLoadMoreThumbnails()) return;
			var lastThumbnail = this.playlist_ar[this.playlist_ar.length - 1].thumbnail;
			clearTimeout(this.loadInifiniteId_to);
			this.loadInifiniteId_to = setTimeout(function(){
				if(lastThumbnail.getGlobalY() + lastThumbnail.finalH < FWDVRLUtils.getViewportSize().h){
					self.loadMore();
				}
			}, 500);
		};
		
		this.init();
	};
	
	/* set prototype */
	FWDVUGPVerticalThumbnailsManager.setPrototype = function(){
		FWDVUGPVerticalThumbnailsManager.prototype = new FWDVRLDisplayObject("div", "relative");
	};
	
	FWDVUGPVerticalThumbnailsManager.OPEN_LIGHTBOX = "openLightbox";
	FWDVUGPVerticalThumbnailsManager.CATEGORY_UPDATE = "categoryUpdate";
	FWDVUGPVerticalThumbnailsManager.ERROR = "error";
	
	FWDVUGPVerticalThumbnailsManager.prototype = null;
	window.FWDVUGPVerticalThumbnailsManager = FWDVUGPVerticalThumbnailsManager;
	
}(window));